<?php

/**
 * API de Consulta de CT-e
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../../vendor/autoload.php';

use NFePHP\CTe\Tools;
use NFePHP\CTe\Common\Standardize;
use NFePHP\Common\Certificate;

try {
    $json = file_get_contents('php://input');
    $dados = json_decode($json, true);

    if (!$dados) throw new Exception('JSON inválido');

    if (!isset($dados['chave_acesso'])) throw new Exception('Chave de acesso é obrigatória');
    if (!isset($dados['emitente']['cnpj'])) throw new Exception('CNPJ do emitente é obrigatório');

    $chaveAcesso = preg_replace('/[^0-9]/', '', $dados['chave_acesso']);
    if (strlen($chaveAcesso) != 44) throw new Exception('Chave de acesso deve ter 44 dígitos');

    $cnpj = preg_replace('/[^0-9]/', '', $dados['emitente']['cnpj']);
    $certificadoPath = __DIR__ . "/../../certificados/empresas/{$cnpj}/{$cnpj}.pfx";

    if (!file_exists($certificadoPath)) throw new Exception("Certificado não encontrado");

    $configCertificado = require __DIR__ . '/../../config_certificado.php';
    $certificado = \App\Core\CertificateHelper::loadPfx($certificadoPath, $configCertificado['senha_certificado']);

    $config = [
        "atualizacao" => date('Y-m-d H:i:s'),
        "tpAmb" => 1,
        "razaosocial" => $dados['emitente']['nome'] ?? '',
        "cnpj" => $cnpj,
        "siglaUF" => $dados['emitente']['estado'] ?? 'PE',
        "schemes" => "PL_CTe_300",
        "versao" => '3.00'
    ];

    $configJson = json_encode($config);
    $tools = new Tools($configJson, $certificado);

    $response = $tools->sefazConsultaChave($chaveAcesso);
    $st = new Standardize($response);
    $std = $st->toStd();

    if (isset($std->protCTe->infProt->cStat)) {
        $cStat = $std->protCTe->infProt->cStat;
        $xMotivo = $std->protCTe->infProt->xMotivo;

        $situacao = 'Outro';
        if (in_array($cStat, [100, 150])) $situacao = 'Autorizado';
        elseif ($cStat == 101) $situacao = 'Cancelado';

        http_response_code(200);
        echo json_encode([
            'success' => in_array($cStat, [100, 150, 101]),
            'chave_acesso' => $chaveAcesso,
            'cStat' => $cStat,
            'xMotivo' => $xMotivo,
            'protocolo' => $std->protCTe->infProt->nProt ?? null,
            'data_autorizacao' => $std->protCTe->infProt->dhRecbto ?? null,
            'situacao' => $situacao
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    } else {
        throw new Exception('Resposta inválida da SEFAZ');
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

