<?php

/**
 * API de Cancelamento de CT-e
 */

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../../vendor/autoload.php';

use App\Services\CTEService;

try {
    $json = file_get_contents('php://input');
    $dados = json_decode($json, true);

    if (!$dados) throw new Exception('JSON inválido');

    $camposObrigatorios = ['chave_acesso', 'justificativa', 'protocolo', 'emitente'];
    foreach ($camposObrigatorios as $campo) {
        if (!isset($dados[$campo])) throw new Exception("Campo $campo é obrigatório");
    }

    if (strlen($dados['justificativa']) < 15) {
        throw new Exception('Justificativa deve ter no mínimo 15 caracteres');
    }

    $service = new CTEService();
    $resultado = $service->cancelar($dados);

    http_response_code($resultado['success'] ? 200 : 400);
    echo json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

