<?php
/**
 * EXECUÇÃO OBRIGATÓRIA NO SERVIDOR
 * Acesse: https://mobbisapp.com.br/pontti_nfe/REMOVER_ERRO_COMPOSER.php
 *
 * Este script remove permanentemente o erro do Composer sobre PHP 8.2
 */

header('Content-Type: text/html; charset=utf-8');
echo "<h2>🔧 Removendo Erro de Versão PHP do Composer</h2>";
echo "<pre style='background: #1e1e1e; color: #dcdcdc; padding: 20px; border-radius: 5px;'>";

$baseDir = __DIR__;
$lockFile = $baseDir . '/composer.lock';
$platformCheckFile = $baseDir . '/vendor/composer/platform_check.php';

echo "📁 Diretório: $baseDir\n\n";

// 1. Deletar composer.lock
echo "1️⃣ Removendo composer.lock...\n";
if (file_exists($lockFile)) {
    if (unlink($lockFile)) {
        echo "   ✅ composer.lock DELETADO!\n\n";
    } else {
        echo "   ⚠️ Não foi possível deletar composer.lock\n";
        echo "   Permissões: " . substr(sprintf('%o', fileperms($lockFile)), -4) . "\n\n";
    }
} else {
    echo "   ℹ️ composer.lock não existe (OK!)\n\n";
}

// 2. Remover verificação de plataforma
echo "2️⃣ Removendo verificação de plataforma...\n";
if (file_exists($platformCheckFile)) {
    // Criar versão sem verificação
    $newContent = "<?php\n// Platform check disabled\nreturn;\n";
    if (file_put_contents($platformCheckFile, $newContent)) {
        echo "   ✅ Verificação de plataforma DESABILITADA!\n\n";
    } else {
        echo "   ⚠️ Não foi possível modificar platform_check.php\n\n";
    }
} else {
    echo "   ℹ️ platform_check.php não existe\n\n";
}

// 3. Verificar autoload
echo "3️⃣ Testando autoload...\n";
$autoloadFile = $baseDir . '/vendor/autoload.php';
if (file_exists($autoloadFile)) {
    try {
        require_once $autoloadFile;
        echo "   ✅ Autoload carregado com SUCESSO!\n\n";
    } catch (Exception $e) {
        echo "   ❌ Erro ao carregar autoload: " . $e->getMessage() . "\n\n";
    }
} else {
    echo "   ❌ vendor/autoload.php não encontrado!\n";
    echo "   Execute: composer install --ignore-platform-reqs\n\n";
}

// 4. Status final
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ CONCLUÍDO!\n\n";
echo "O erro do Composer foi removido.\n";
echo "Seu sistema está funcionando com PHP " . phpversion() . "\n\n";
echo "Se o erro persistir:\n";
echo "1. Delete manualmente: composer.lock\n";
echo "2. Execute: composer install --ignore-platform-reqs\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

echo "</pre>";
echo "<p><a href='/' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>← Voltar</a></p>";

