# 🏠 Página Inicial - Sistema de NF-e

## 📋 Visão Geral

A página inicial do sistema de NF-e foi criada para fornecer uma interface amigável e profissional para acessar a API e seus recursos.

---

## 🌐 URLs de Acesso

### Página Principal
```
https://mobbisapp.com.br/pontti_nfe/
```

### Documentação
```
https://mobbisapp.com.br/pontti_nfe/docs/
```

### Status da API
```
https://mobbisapp.com.br/pontti_nfe/status.php
```

---

## 🎯 Funcionalidades da Página

### ✅ Interface Responsiva
- Design moderno e profissional
- Gradiente azul elegante
- Cards com hover effects
- Responsivo para mobile e desktop

### ✅ Links Principais
1. **📚 Documentação da API** - Acesso completo à documentação
2. **🏢 Systhema Tecnologia** - Site da empresa desenvolvedora
3. **📱 MobbiS App** - Sistema principal de negócios

### ✅ Status em Tempo Real
- Verificação automática do status da API
- Indicador visual (ponto pulsante)
- Atualização a cada 30 segundos
- Mostra se SEFAZ está conectado

### ✅ Informações da API
- Versão atual (1.1.1)
- Ambiente de produção
- URL base da API
- Características principais

---

## 🔧 Como Funciona o Roteamento

### Detecção Inteligente
O sistema detecta automaticamente o tipo de requisição:

```php
// Verificar se é uma requisição de API
$isApiRequest = strpos($requestUri, '/api/') !== false ||
                strpos($requestUri, '/status.php') !== false ||
                (isset($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false) ||
                (isset($_SERVER['CONTENT_TYPE']) && strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false);
```

### Tipos de Requisição

| Tipo | Comportamento | Exemplo |
|------|---------------|---------|
| **Navegador** | Mostra página HTML | `GET /pontti_nfe/` |
| **API** | Processa JSON | `POST /pontti_nfe/api/nfe/emitir.php` |
| **Status** | Retorna JSON | `GET /pontti_nfe/status.php` |

---

## 📁 Arquivos Criados

### 1. `index.html`
- Página principal com design moderno
- JavaScript para verificação de status
- Links para todos os recursos

### 2. `index.php` (modificado)
- Roteador inteligente
- Detecta tipo de requisição
- Redireciona para HTML ou API

### 3. `api_router.php`
- Código original do index.php
- Processa requisições de API
- Mantém funcionalidade original

### 4. `.htaccess`
- Configurações de segurança
- Headers CORS
- Compressão GZIP
- Cache de arquivos

### 5. `teste_pagina.html`
- Página de teste
- Verificação de funcionalidades
- Links de teste

---

## 🎨 Design e UX

### Paleta de Cores
- **Primária:** Gradiente azul (#1e3c72 → #2a5298)
- **Secundária:** Gradiente roxo (#667eea → #764ba2)
- **Sucesso:** Gradiente azul claro (#4facfe → #00f2fe)
- **Atenção:** Gradiente rosa (#f093fb → #f5576c)

### Elementos Visuais
- **Cards flutuantes** com sombra
- **Animações suaves** no hover
- **Ícones emoji** para identificação rápida
- **Status pulsante** para indicar atividade

### Responsividade
- **Desktop:** 3 colunas de cards
- **Tablet:** 2 colunas de cards
- **Mobile:** 1 coluna de cards

---

## 🔍 Verificação de Status

### JavaScript Automático
```javascript
async function checkAPIStatus() {
    try {
        const response = await fetch('status.php');
        const data = await response.json();

        if (data.status === 'online' && data.sefaz === 'conectado') {
            // Mostrar status online
        } else {
            // Mostrar status com problemas
        }
    } catch (error) {
        // Tratar erro de conexão
    }
}
```

### Indicadores Visuais
- **🟢 Verde:** Sistema online, SEFAZ conectado
- **🔴 Vermelho:** Sistema com problemas
- **⚪ Cinza:** Verificando status

---

## 🚀 Benefícios

### Para Desenvolvedores
- **Acesso rápido** à documentação
- **Verificação visual** do status da API
- **Links organizados** para todos os recursos

### Para Usuários Finais
- **Interface profissional** e confiável
- **Informações claras** sobre o sistema
- **Navegação intuitiva**

### Para a Empresa
- **Presença online** profissional
- **Marketing** para Systhema Tecnologia e MobbiS App
- **Credibilidade** do sistema

---

## 📱 Teste em Dispositivos

### Desktop
- Chrome, Firefox, Safari, Edge
- Resolução mínima: 1024x768
- Resolução recomendada: 1920x1080

### Mobile
- iOS Safari, Chrome Mobile
- Android Chrome, Samsung Browser
- Resolução mínima: 320px

### Tablet
- iPad Safari, Chrome
- Android Tablet
- Resolução: 768px - 1024px

---

## 🔧 Manutenção

### Atualizações de Versão
Para atualizar a versão mostrada na página:

1. Editar `index.html`:
```html
<div class="version-badge">Versão 1.2.0 - Ambiente de Produção</div>
```

2. Atualizar informações relevantes

### Adicionar Novos Links
Para adicionar novos cards na página:

1. Copiar estrutura do card existente
2. Modificar ícone, título, descrição e link
3. Escolher cor do botão (btn, btn-secondary, btn-success)

### Modificar Cores
Para alterar a paleta de cores:

1. Editar variáveis CSS no `index.html`
2. Atualizar gradientes nos botões
3. Testar contraste e legibilidade

---

## 📞 Suporte

### Problemas com a Página
- Verificar se `index.html` existe
- Confirmar configuração do `.htaccess`
- Testar acesso direto ao `index.php`

### Problemas com API
- Verificar se `api_router.php` existe
- Confirmar que requisições JSON funcionam
- Testar endpoint `/status.php`

### Contato
- **Email:** contato@pontti.com.br
- **Telefone:** (81) 2011-3434
- **Website:** [pontti.com.br](https://pontti.com.br)

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**
