# 🚚 MDF-e - Situação Atual

## ⚠️ ATENÇÃO: MODO SIMULAÇÃO

O sistema de MDF-e está atualmente em **MODO SIMULAÇÃO** para desenvolvimento e testes.

### ✅ O que está FUNCIONANDO:

1. **Geração de XML** - Formato correto conforme layout SEFAZ 3.00
2. **Assinatura Digital** - Certificado A1 validado
3. **Chave de Acesso** - Calculada corretamente (módulo 11)
4. **XML Protocolado** - Estrutura `<mdfeProc>` completa
5. **PDF (DAMDFE)** - Gerado usando NFePHP
6. **Estrutura de Arquivos** - Organizada por CNPJ/data
7. **API REST** - Endpoints funcionais

### ⚠️ O que é SIMULADO:

1. **Protocolo SEFAZ** - Gerado aleatoriamente (não é real)
2. **Comunicação SEFAZ** - Não envia para webservices reais
3. **Validação** - XML não é validado pela SEFAZ

---

## 🎯 Para Usar em PRODUÇÃO REAL:

### Opção 1: Biblioteca Específica
```bash
# Não existe biblioteca NFePHP completa para MDF-e
# Alternativas:
```
- **TecnoSpeed MDF-e** (paga) - https://tecnospeed.com.br
- **Focus NFe** (paga) - https://focusnfe.com.br
- **eNotas** (paga) - https://enotas.com.br

### Opção 2: Implementar Webservice Direto
Requer:
1. Certificado A1 válido e dentro da validade
2. Conhecimento de webservices SOAP
3. Tratar todos os cenários (contingência, eventos, etc.)
4. Manter atualizado com mudanças da SEFAZ

---

## 📋 Como Usar (Modo Simulação)

### Emissão de MDF-e:
```bash
POST http://localhost/pontti_nfe/api/mdfe/emitir.php
Content-Type: application/json

{
  "emitente": {...},
  "veiculo": {...},
  "condutores": [...],
  "totalizadores": {...}
}
```

### Resposta:
```json
{
  "success": true,
  "chave_acesso": "26251021497109000156580010000000011853466748",
  "protocolo": "126250000913019",
  "cStat": "100",
  "message": "MDF-e emitido com sucesso [SIMULADO]"
}
```

---

## 🔧 Configuração

Em `src/Services/MDFeService.php`:

```php
private $modoSimulacao = true;  // TRUE = Simulação, FALSE = Real (não implementado)
private $tpAmb = 2;  // 1 = Produção, 2 = Homologação
```

---

## ✅ Recomendação

**Para ambiente de PRODUÇÃO:**
1. Use serviço terceirizado (TecnoSpeed, Focus NFe, etc.)
2. OU contrate desenvolvedor especializado em SEFAZ
3. OU aguarde biblioteca oficial NFePHP para MDF-e

**Para DESENVOLVIMENTO/TESTES:**
- Modo simulação atual é suficiente
- XML gerado está correto
- PDF funcional
- Estrutura preparada para futuras melhorias

---

**Data:** 21/10/2025
**Status:** ✅ FUNCIONAL (Simulação)
**Produção:** ❌ Requer implementação adicional

