# 📮 Coleção Postman - MDF-e

Guia rápido com todos os JSONs prontos para testar no Postman.

---

## 🚚 1. EMITIR MDF-e

**POST** `http://localhost/pontti_nfe/api/mdfe/emitir.php`

**Headers:**
```
Content-Type: application/json
```

**Body (raw - JSON):**
```json
{
    "emitente": {
        "nome": "PRINT JET DIGITAL",
        "nome_fantasia": "Print Jet",
        "cnpj": "21497109000156",
        "inscricao_estadual": "093218028",
        "estado": "PE",
        "cidade": "Recife",
        "endereco": "Rua Frei Cassimiro",
        "numero": "644",
        "bairro": "Santo Amaro",
        "cep": "50100260",
        "telefone": "(81) 99999-9999",
        "email": "atendimento@printjetdigital.com.br"
    },
    "mdfe": {
        "numero": "6",
        "serie": "001"
    },
    "tipo_emitente": 2,
    "modal": 1,
    "uf_inicio": "PE",
    "uf_fim": "SP",
    "veiculo": {
        "codigo_interno": "VEI001",
        "placa": "ABC1234",
        "renavam": "12345678901",
        "tara": 8000,
        "capacidade_kg": 25000,
        "capacidade_m3": 80,
        "tipo_rodado": "02",
        "tipo_carroceria": "00",
        "uf": "PE"
    },
    "condutores": [
        {
            "nome": "João da Silva",
            "cpf": "05138670409"
        }
    ],
    "municipios_carregamento": [
        {
            "codigo_municipio": 2611606,
            "nome": "Recife",
            "nfes": [
                {
                    "chave_acesso": "35251012345678000195550010000000011234567890"
                }
            ]
        }
    ],
    "municipios_descarregamento": [
        {
            "codigo_municipio": 3550308,
            "nome": "São Paulo",
            "nfes": [
                {
                    "chave_acesso": "35251012345678000195550010000000011234567890"
                }
            ]
        }
    ],
    "totalizadores": {
        "quantidade_nfe": 1,
        "quantidade_cte": 0,
        "quantidade_mdfe": 0,
        "valor_carga": 5000.00,
        "codigo_unidade": "01",
        "peso_carga": 2500.0000
    },
    "informacoes_complementares": "Transporte de mercadorias"
}
```

**⚠️ LEMBRE-SE:**
- Alterar `mdfe.numero` para o próximo número disponível
- Usar chaves de NF-e válidas

---

## 🏁 2. ENCERRAR MDF-e

**POST** `http://localhost/pontti_nfe/api/mdfe/encerrar.php`

**Headers:**
```
Content-Type: application/json
```

**Body (raw - JSON):**
```json
{
    "chave_acesso": "COLOQUE_A_CHAVE_DO_MDFE_AQUI",
    "protocolo": "COLOQUE_O_PROTOCOLO_AQUI",
    "cnpj": "21497109000156",
    "uf_encerramento": "SP",
    "municipio_encerramento": {
        "codigo": "3550308",
        "nome": "São Paulo"
    }
}
```

**⚠️ LEMBRE-SE:**
- Substituir `chave_acesso` e `protocolo` pelos dados do MDF-e autorizado

---

## ❌ 3. CANCELAR MDF-e

**POST** `http://localhost/pontti_nfe/api/mdfe/cancelar.php`

**Headers:**
```
Content-Type: application/json
```

**Body (raw - JSON):**
```json
{
    "chave_acesso": "COLOQUE_A_CHAVE_DO_MDFE_AQUI",
    "protocolo": "COLOQUE_O_PROTOCOLO_AQUI",
    "cnpj": "21497109000156",
    "justificativa": "Erro no preenchimento dos dados do MDF-e, necessário cancelamento"
}
```

**⚠️ LEMBRE-SE:**
- Justificativa mínima: 15 caracteres
- Só pode cancelar MDF-e NÃO encerrado
- Prazo: até 24 horas após autorização

---

## 👤 4. INCLUIR CONDUTOR

**POST** `http://localhost/pontti_nfe/api/mdfe/incluir_condutor.php`

**Headers:**
```
Content-Type: application/json
```

**Body (raw - JSON):**
```json
{
    "chave_acesso": "COLOQUE_A_CHAVE_DO_MDFE_AQUI",
    "cnpj": "21497109000156",
    "condutor": {
        "nome": "Maria Santos Silva",
        "cpf": "12345678909"
    }
}
```

**⚠️ LEMBRE-SE:**
- Só pode incluir condutor em MDF-e NÃO encerrado

---

## 📊 Exemplo de Fluxo Completo

### Passo 1: Emitir MDF-e
```
POST /api/mdfe/emitir.php
→ Recebe: chave_acesso e protocolo
```

### Passo 2: (Opcional) Incluir Condutor
```
POST /api/mdfe/incluir_condutor.php
→ Usa: chave_acesso do Passo 1
```

### Passo 3: Encerrar MDF-e
```
POST /api/mdfe/encerrar.php
→ Usa: chave_acesso e protocolo do Passo 1
```

### Alternativa: Cancelar (em vez de Encerrar)
```
POST /api/mdfe/cancelar.php
→ Usa: chave_acesso e protocolo do Passo 1
→ Prazo: 24 horas
```

---

## 🎯 Dicas para Testes

### 1. Numeração Sequencial
Sempre incremente o número do MDF-e:
```json
"mdfe": {
    "numero": "6",  // Próximo disponível
    "serie": "001"
}
```

### 2. Chaves de NF-e Válidas
Use chaves com DV correto. Exemplo genérico válido:
```
35251012345678000195550010000000011234567890
```

### 3. Placa do Veículo
Se já existe MDF-e aberto para a mesma placa e destino, você receberá erro 611.

**Solução:**
- Encerre o MDF-e anterior, OU
- Use outra placa

### 4. Justificativa de Cancelamento
Mínimo 15 caracteres. Exemplos:
```
"Erro no preenchimento dos dados do MDF-e"
"Viagem cancelada por problema mecânico no veículo"
"Dados incorretos informados no manifesto"
```

---

## 📝 Tabela de Referência - Códigos IBGE

### Principais Municípios:

| Cidade | UF | Código IBGE |
|--------|----|-----------:|
| Recife | PE | 2611606 |
| São Paulo | SP | 3550308 |
| Rio de Janeiro | RJ | 3304557 |
| Belo Horizonte | MG | 3106200 |
| Salvador | BA | 2927408 |
| Brasília | DF | 5300108 |
| Fortaleza | CE | 2304400 |
| Manaus | AM | 1302603 |
| Curitiba | PR | 4106902 |
| Porto Alegre | RS | 4314902 |

---

## 🔍 Verificando Respostas

### Sucesso (cStat = 100):
```json
{
    "success": true,
    "chave_acesso": "26251021497109000156580010000000051808712025",
    "protocolo": "926250000006530",
    "cStat": "100",
    "message": "MDF-e emitido com sucesso"
}
```

### Sucesso em Evento (cStat = 135):
```json
{
    "success": true,
    "cStat": "135",
    "xMotivo": "Evento registrado e vinculado ao MDF-e"
}
```

### Erro:
```json
{
    "success": false,
    "cStat": "611",
    "error": "MDF-e rejeitado [611]: Existe MDF-e não encerrado para esta placa..."
}
```

---

## 🚀 Collection Postman (Importar)

Você pode criar uma Collection no Postman com estes 4 endpoints:

1. **MDF-e - Emitir**
2. **MDF-e - Encerrar**
3. **MDF-e - Cancelar**
4. **MDF-e - Incluir Condutor**

Salve as variáveis:
- `{{base_url}}` = `http://localhost/pontti_nfe`
- `{{chave_acesso}}` = (preencher após emissão)
- `{{protocolo}}` = (preencher após emissão)

---

**Pronto para usar! 🎊**


