# 📝 Guia Rápido - Carta de Correção Eletrônica (CC-e)

## 🎯 O que é?

A **Carta de Correção Eletrônica (CC-e)** permite corrigir pequenos erros em uma NF-e já autorizada, sem precisar cancelá-la.

---

## 🔗 Endpoint

```
POST /api/nfe/carta-correcao.php
```

---

## 📋 JSON de Request (Obrigatório)

```json
{
  "chave_acesso": "26251021497109000156550020000000641000010643",
  "empresa": {
    "nome": "PRINT JET DIGITAL",
    "cnpj": "21497109000156",
    "inscricao_estadual": "093218028",
    "estado": "PE"
  },
  "correcao": "Corrigir endereco do destinatario: Rua das Flores, 456 - Bairro Centro",
  "numero_sequencial": 1
}
```

---

## ⚠️ Campo Crítico: numero_sequencial

**SEMPRE** informe o `numero_sequencial`:

| Situação | numero_sequencial | Observação |
|----------|-------------------|------------|
| **Primeira CC-e** desta NF-e | `1` | Sempre comece com 1 |
| **Segunda CC-e** desta NF-e | `2` | Incremente para 2 |
| **Terceira CC-e** desta NF-e | `3` | Incremente para 3 |
| **E assim sucessivamente...** | `4, 5, 6...` | Sempre sequencial |

---

## ❌ Erro 573 - Duplicidade de Evento

**Mensagem:**
```json
{
  "success": false,
  "cStat": "573",
  "error": "Rejeição [573]: Duplicidade de Evento"
}
```

**Causa:** Você já enviou uma CC-e com esse `numero_sequencial` para essa NF-e.

**Solução:** Incremente o número:
```json
// ❌ Tentou enviar com numero_sequencial: 1 (já existe)
// ✅ Envie com numero_sequencial: 2
{
  "numero_sequencial": 2,
  "correcao": "Sua nova correção aqui..."
}
```

---

## ✅ O que PODE corrigir

- ✅ Endereços (rua, número, bairro, CEP)
- ✅ Descrições de produtos
- ✅ Dados cadastrais do destinatário (nome, telefone, email)
- ✅ Informações complementares

---

## ❌ O que NÃO PODE corrigir

- ❌ Valores (preço, total, impostos)
- ❌ Quantidades
- ❌ CPF/CNPJ do destinatário
- ❌ Data de emissão
- ❌ NCM, CFOP
- ❌ Adicionar ou remover itens

---

## 📊 Resposta de Sucesso

```json
{
  "success": true,
  "chave_acesso": "26251021497109000156550020000000641000010643",
  "protocolo_cce": "126250107478536",
  "numero_sequencial": 1,
  "data_registro": "2025-10-10T11:08:42-03:00",
  "cStat": "135",
  "xml_path": "/pontti_nfe/arquivos/.../CCe_..._v1.xml",
  "pdf_path": "/pontti_nfe/arquivos/.../CCe_..._v1.pdf",
  "message": "Carta de Correção registrada com sucesso"
}
```

**O sistema gera automaticamente:**
- ✅ XML da CC-e salvo em `xml_path`
- ✅ PDF da CC-e salvo em `pdf_path`

---

## 📂 Onde os Arquivos São Salvos

```
arquivos/21497109000156/nfe/eventos/cce/2025_10/
├── CCe_{CHAVE}_v1.xml  ← 1ª correção (XML)
├── CCe_{CHAVE}_v1.pdf  ← 1ª correção (PDF)
├── CCe_{CHAVE}_v2.xml  ← 2ª correção (XML)
├── CCe_{CHAVE}_v2.pdf  ← 2ª correção (PDF)
└── ...
```

---

## 🧪 Exemplo de Teste Rápido

```bash
curl -X POST http://localhost/pontti_nfe/api/nfe/carta-correcao.php \
  -H "Content-Type: application/json" \
  -d '{
    "chave_acesso": "SUA_CHAVE_AQUI",
    "empresa": {
      "nome": "PRINT JET DIGITAL",
      "cnpj": "21497109000156",
      "inscricao_estadual": "093218028",
      "estado": "PE"
    },
    "correcao": "Corrigir endereco: Rua Exemplo, 123 - Bairro Teste",
    "numero_sequencial": 1
  }'
```

**⚠️ Substitua `SUA_CHAVE_AQUI` pela chave de uma NF-e real que você emitiu!**

---

## 📞 Códigos SEFAZ - CC-e

| cStat | Descrição | Ação |
|-------|-----------|------|
| **135** | ✅ Evento registrado e vinculado | Sucesso! |
| **478** | ❌ Sequencial fora de ordem | Use próximo número sequencial |
| **573** | ❌ Duplicidade de evento | Incremente numero_sequencial |
| **591** | ❌ CC-e já registrada | Verifique se não enviou duplicado |

---

## 💡 Dica

**Não sabe qual número sequencial usar?**
- Sempre comece com `1`
- Se der erro 573, tente `2`
- Se der erro 573 novamente, tente `3`
- E assim sucessivamente...

---

**Desenvolvido por [Systhema Tecnologia](https://pontti.com.br)**

