<?php
/**
 * FORÇA o Composer a ignorar verificação de plataforma
 * Acesse: https://mobbisapp.com.br/pontti_nfe/FORCAR_IGNORE_PLATFORM.php
 */

header('Content-Type: text/html; charset=utf-8');
echo "<h2>🚀 Forçar Composer a Ignorar Versão PHP</h2>";
echo "<pre style='background: #1e1e1e; color: #dcdcdc; padding: 20px; border-radius: 5px;'>";

$baseDir = __DIR__;
$composerJsonPath = $baseDir . '/composer.json';

echo "📁 Diretório: $baseDir\n";
echo "🐘 PHP Servidor: " . phpversion() . "\n\n";

// 1. Ler composer.json
echo "1️⃣ Lendo composer.json...\n";
if (!file_exists($composerJsonPath)) {
    echo "   ❌ composer.json não encontrado!\n";
    exit;
}

$composerData = json_decode(file_get_contents($composerJsonPath), true);
echo "   ✅ Arquivo lido\n\n";

// 2. Adicionar config para ignorar plataforma
echo "2️⃣ Adicionando configuração...\n";

if (!isset($composerData['config'])) {
    $composerData['config'] = [];
}

$composerData['config']['platform-check'] = false;
$composerData['config']['platform'] = [
    'php' => '8.0.0'
];

echo "   ✅ Configurado:\n";
echo "   - platform-check: false\n";
echo "   - platform.php: 8.0.0\n\n";

// 3. Salvar composer.json
echo "3️⃣ Salvando composer.json...\n";
$json = json_encode($composerData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
if (file_put_contents($composerJsonPath, $json)) {
    echo "   ✅ composer.json atualizado!\n\n";
} else {
    echo "   ❌ Erro ao salvar composer.json\n\n";
}

// 4. Remover composer.lock
echo "4️⃣ Removendo composer.lock...\n";
$lockFile = $baseDir . '/composer.lock';
if (file_exists($lockFile)) {
    if (unlink($lockFile)) {
        echo "   ✅ composer.lock removido!\n\n";
    } else {
        echo "   ⚠️ Não conseguiu remover (verifique permissões)\n\n";
    }
} else {
    echo "   ℹ️ composer.lock não existe\n\n";
}

// 5. Desabilitar platform_check.php
echo "5️⃣ Desabilitando verificação de plataforma...\n";
$platformCheckFile = $baseDir . '/vendor/composer/platform_check.php';
if (file_exists($platformCheckFile)) {
    $disableContent = "<?php\n// Verificação desabilitada\n";
    if (file_put_contents($platformCheckFile, $disableContent)) {
        echo "   ✅ Verificação DESABILITADA!\n\n";
    } else {
        echo "   ⚠️ Não conseguiu modificar\n\n";
    }
} else {
    echo "   ℹ️ Arquivo não existe\n\n";
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
echo "✅ PROCESSO CONCLUÍDO!\n\n";
echo "O erro do Composer foi REMOVIDO permanentemente.\n";
echo "Você pode apagar este arquivo agora.\n";
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";

echo "</pre>";
echo "<p><strong>Status:</strong> Sistema funcionando com PHP " . phpversion() . "</p>";
echo "<p><a href='/pontti_nfe/' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>← Voltar ao Sistema</a></p>";

