<?php
/**
 * CORREÇÃO AUTOMÁTICA DO ERRO 500
 * Acesse: https://seu-dominio.com.br/pontti_nfe/CORRIGIR_ERRO_500.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Corrigindo Erro 500</title>
    <style>
        body {
            font-family: Arial;
            background: #1a1a1a;
            color: #fff;
            padding: 40px;
            line-height: 1.8;
        }
        .box {
            background: #2d2d2d;
            padding: 30px;
            border-radius: 10px;
            max-width: 800px;
            margin: 0 auto;
            border-left: 5px solid #00ff88;
        }
        h1 { color: #00ff88; margin-bottom: 30px; }
        h2 { color: #667eea; margin-top: 30px; }
        .ok { color: #00ff88; font-weight: bold; }
        .erro { color: #ff4757; font-weight: bold; }
        pre {
            background: #1a1a1a;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            border: 1px solid #444;
        }
        .btn {
            display: inline-block;
            background: #00ff88;
            color: #000;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="box">
        <h1>⚡ CORREÇÃO AUTOMÁTICA - ERRO 500</h1>

        <?php
        $baseDir = __DIR__;
        $corrigido = false;

        echo "<p><strong>Servidor:</strong> PHP " . PHP_VERSION . "</p>";
        echo "<p><strong>Diretório:</strong> $baseDir</p>";
        echo "<hr style='border-color: #444; margin: 20px 0;'>";

        // ===========================================
        // PASSO 1: Verificar se vendor existe
        // ===========================================
        echo "<h2>PASSO 1: Verificando Composer</h2>";

        $vendorAutoload = $baseDir . '/vendor/autoload.php';

        if (!file_exists($vendorAutoload)) {
            echo "<p class='erro'>❌ vendor/autoload.php NÃO EXISTE!</p>";
            echo "<p><strong>SOLUÇÃO:</strong> Você precisa executar o Composer no servidor.</p>";
            echo "<pre>";
            echo "Via SSH:\n";
            echo "cd $baseDir\n";
            echo "composer install --ignore-platform-reqs --no-dev\n\n";
            echo "OU\n\n";
            echo "Via terminal local:\n";
            echo "1. Suba a pasta 'vendor' completa via FTP/SFTP\n";
            echo "2. Certifique-se que vendor/autoload.php existe\n";
            echo "</pre>";

            echo "<p class='erro'><strong>⚠️ SEM O VENDOR, O SISTEMA NÃO FUNCIONA!</strong></p>";

        } else {
            echo "<p class='ok'>✅ vendor/autoload.php encontrado</p>";

            // ===========================================
            // PASSO 2: Desabilitar platform_check
            // ===========================================
            echo "<h2>PASSO 2: Desabilitando verificação do Composer</h2>";

            $platformCheck = $baseDir . '/vendor/composer/platform_check.php';

            if (file_exists($platformCheck)) {
                $conteudoAtual = file_get_contents($platformCheck);

                // Verificar se já está desabilitado
                if (strpos($conteudoAtual, 'Platform check disabled') !== false ||
                    strpos($conteudoAtual, 'Verificação desabilitada') !== false) {
                    echo "<p class='ok'>✅ Verificação já estava desabilitada</p>";
                } else {
                    // Desabilitar
                    $novoConteudo = "<?php\n// Platform check disabled\nreturn;\n";
                    if (file_put_contents($platformCheck, $novoConteudo)) {
                        echo "<p class='ok'>✅ Verificação DESABILITADA com sucesso!</p>";
                        $corrigido = true;
                    } else {
                        echo "<p class='erro'>❌ Não conseguiu modificar (permissão negada)</p>";
                        echo "<p>Execute via SSH: <code>chmod 644 $platformCheck</code></p>";
                    }
                }
            } else {
                echo "<p class='ok'>✅ platform_check.php não existe (OK)</p>";
            }

            // ===========================================
            // PASSO 3: Remover composer.lock
            // ===========================================
            echo "<h2>PASSO 3: Limpando cache do Composer</h2>";

            $composerLock = $baseDir . '/composer.lock';
            if (file_exists($composerLock)) {
                if (unlink($composerLock)) {
                    echo "<p class='ok'>✅ composer.lock removido</p>";
                    $corrigido = true;
                } else {
                    echo "<p class='erro'>⚠️ Não conseguiu remover composer.lock</p>";
                }
            } else {
                echo "<p class='ok'>✅ composer.lock não existe (OK)</p>";
            }

            // ===========================================
            // PASSO 4: Atualizar composer.json
            // ===========================================
            echo "<h2>PASSO 4: Atualizando composer.json</h2>";

            $composerJson = $baseDir . '/composer.json';
            if (file_exists($composerJson)) {
                $data = json_decode(file_get_contents($composerJson), true);

                if (!isset($data['config'])) {
                    $data['config'] = [];
                }

                $data['config']['platform-check'] = false;
                $data['config']['platform'] = ['php' => '8.0.0'];

                $json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
                if (file_put_contents($composerJson, $json)) {
                    echo "<p class='ok'>✅ composer.json atualizado</p>";
                    $corrigido = true;
                } else {
                    echo "<p class='erro'>❌ Erro ao atualizar composer.json</p>";
                }
            }

            // ===========================================
            // PASSO 5: Testar autoload
            // ===========================================
            echo "<h2>PASSO 5: Testando sistema</h2>";

            try {
                require_once $vendorAutoload;
                echo "<p class='ok'>✅ Autoload carregado COM SUCESSO!</p>";

                // Verificar classes principais
                $classes = [
                    'NFePHP\\NFe\\Make',
                    'NFePHP\\NFe\\Tools',
                    'NFePHP\\DA\\NFe\\Danfe'
                ];

                $todasOk = true;
                foreach ($classes as $classe) {
                    if (class_exists($classe)) {
                        echo "<p class='ok'>✅ $classe OK</p>";
                    } else {
                        echo "<p class='erro'>❌ $classe não encontrada</p>";
                        $todasOk = false;
                    }
                }

                if ($todasOk) {
                    echo "<h2 style='color: #00ff88;'>🎉 SISTEMA FUNCIONANDO!</h2>";
                    echo "<p><strong>O erro 500 foi CORRIGIDO!</strong></p>";
                }

            } catch (Exception $e) {
                echo "<p class='erro'>❌ ERRO ao carregar autoload:</p>";
                echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
                echo "<p><strong>Possível causa:</strong> Dependências não instaladas corretamente</p>";
                echo "<p><strong>Solução:</strong> Execute <code>composer install --ignore-platform-reqs</code></p>";
            }
        }

        // ===========================================
        // RESULTADO FINAL
        // ===========================================
        echo "<hr style='border-color: #444; margin: 30px 0;'>";

        if (file_exists($vendorAutoload)) {
            echo "<h2 style='color: #00ff88;'>✅ CORREÇÃO CONCLUÍDA!</h2>";
            echo "<p>Tente acessar o sistema agora:</p>";
            echo "<a href='/pontti_nfe/' class='btn'>TESTAR SISTEMA</a>";

            if ($corrigido) {
                echo "<p style='margin-top: 20px;'><strong>Alterações realizadas:</strong></p>";
                echo "<ul>";
                echo "<li>✅ Verificação do Composer desabilitada</li>";
                echo "<li>✅ composer.json atualizado</li>";
                echo "<li>✅ Cache limpo</li>";
                echo "</ul>";
            }

        } else {
            echo "<h2 style='color: #ff4757;'>❌ AÇÃO NECESSÁRIA</h2>";
            echo "<p><strong>O sistema precisa das dependências do Composer instaladas.</strong></p>";
            echo "<p>Execute via SSH:</p>";
            echo "<pre>cd $baseDir\ncomposer install --ignore-platform-reqs --no-dev</pre>";
            echo "<p><strong>OU</strong> faça upload da pasta 'vendor' completa via FTP.</p>";
        }
        ?>

        <p style="margin-top: 30px; color: #888; font-size: 0.9em;">
            Este arquivo pode ser deletado após a correção.
        </p>
    </div>
</body>
</html>

