# 📋 Como Verificar Logs do Sistema

## 📂 Localização dos Logs

Os logs do sistema ficam em:
```
pontti_nfe/logs/nfe_debug.log
```

---

## 🔍 Visualizar Logs no Windows (PowerShell)

### Ver as últimas 50 linhas:
```powershell
cd pontti_nfe
Get-Content logs/nfe_debug.log -Tail 50
```

### Ver as últimas 100 linhas:
```powershell
Get-Content logs/nfe_debug.log -Tail 100
```

### Ver todo o arquivo:
```powershell
Get-Content logs/nfe_debug.log
```

### Monitorar em tempo real:
```powershell
Get-Content logs/nfe_debug.log -Wait -Tail 20
```

### Limpar o log:
```powershell
Clear-Content logs/nfe_debug.log
```

---

## 📊 O que Procurar nos Logs

### **Emissão de NF-e:**
```
🚀 EMISSÃO 100% REAL E OFICIAL
✅ Cliente é CONSUMIDOR FINAL
✅ XML REAL assinado com sucesso
✅ NFe emitida com sucesso!
```

### **Cancelamento de NF-e:**
```
🚫 CANCELANDO NFe: 26250910214971090001565500100000001123456789
📋 Evento de cancelamento gerado
✅ NFe cancelada com sucesso!
```

### **Inutilização de NF-e:**
```
🚫 INUTILIZANDO NUMERAÇÃO NFe - Série: 001, Números: 101 a 101
📋 Parâmetros de inutilização:
📋 Resposta completa da SEFAZ: {...}
✅ Numeração inutilizada com sucesso!
```

### **Erros:**
```
❌ Erro ao assinar XML
❌ Erro na inutilização
❌ NFe rejeitada [696]
```

---

## 🐛 Debug de Problemas

### 1. Verificar última requisição:
```powershell
Get-Content logs/nfe_debug.log -Tail 30
```

### 2. Procurar por erros específicos:
```powershell
Get-Content logs/nfe_debug.log | Select-String "❌"
```

### 3. Procurar por sucessos:
```powershell
Get-Content logs/nfe_debug.log | Select-String "✅"
```

### 4. Filtrar por data específica:
```powershell
Get-Content logs/nfe_debug.log | Select-String "2025-10-09"
```

---

## 📝 Formato dos Logs

Cada linha do log tem o formato:
```
[2025-10-09 15:30:45] 🚀 EMISSÃO 100% REAL E OFICIAL
```

Onde:
- `[2025-10-09 15:30:45]` - Data e hora
- `🚀` - Emoji indicativo (🚀 = início, ✅ = sucesso, ❌ = erro)
- Mensagem descritiva

---

## 💡 Dicas

1. **Sempre verifique os logs** quando houver erro
2. **Use -Tail 50** para ver apenas as linhas mais recentes
3. **Limpe o log periodicamente** se ficar muito grande
4. **Use Select-String** para filtrar informações específicas
5. **Monitore em tempo real** com `-Wait` durante testes

---

**Desenvolvido por Systhema Tecnologia**

