<?php

declare(strict_types=1);

namespace App\Helpers;

/**
 * Helper para APIs externas (CEP e CNPJ)
 */
class ApiHelper
{
    /**
     * Endpoint para buscar CEP via AJAX
     */
    public static function buscarCep(): void
    {
        header('Content-Type: application/json');

        $cep = $_GET['cep'] ?? $_POST['cep'] ?? '';
        $resultado = CepHelper::buscar($cep);

        if ($resultado) {
            echo json_encode([
                'success' => true,
                'data' => $resultado
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'CEP não encontrado'
            ]);
        }
        exit;
    }

    /**
     * Endpoint para buscar CNPJ via AJAX
     */
    public static function buscarCnpj(): void
    {
        header('Content-Type: application/json');

        $cnpj = $_GET['cnpj'] ?? $_POST['cnpj'] ?? '';

        // Valida primeiro
        if (!CnpjHelper::validar($cnpj)) {
            echo json_encode([
                'success' => false,
                'message' => 'CNPJ inválido'
            ]);
            exit;
        }

        $resultado = CnpjHelper::buscar($cnpj);

        if ($resultado) {
            echo json_encode([
                'success' => true,
                'data' => $resultado
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'CNPJ não encontrado'
            ]);
        }
        exit;
    }
}

