<?php

declare(strict_types=1);

namespace App\Controllers;

class PreVendasController extends VendasController
{
    protected array $moduleConfig = [
        'origin' => 'dav',
        'slug' => 'pre-vendas',
        'routeBase' => '/pre-vendas',
        'viewBase' => 'pre-vendas',
        'icon' => 'bi bi-clipboard-check',
        'createIcon' => 'bi bi-clipboard-plus',
        'singular' => 'DAV',
        'plural' => 'DAVs',
        'subtitle' => 'Controle seus DAVs (Pré-vendas) antes de faturar',
        'createSubtitle' => 'Preencha a DAV com os itens e condições acordadas',
        'numberPrefix' => 'DAV-',
        'statusModule' => 'pre_vendas',
        'generateReceivablesDefault' => false,
        'updateStockDefault' => false,
        'conversionEnabled' => true,
        'newButtonLabel' => 'Nova DAV',
        'emptyItemsMessage' => 'Adicione pelo menos um item à DAV!',
        'saveLabel' => 'Salvar DAV',
        'cancelLabel' => 'Cancelar',
        'formId' => 'form-dav',
    ];

    public function converterParaVenda(): void
    {
        try {
            $id = (int) $this->request->post('id');

            if (!$id) {
                $this->error('ID da DAV não informado');
                return;
            }

            $originAtual = $this->moduleOrigin();
            $dav = $this->getVenda($id, $originAtual);

            if (!$dav && $originAtual !== 'pre_venda') {
                $originAtual = 'pre_venda';
                $dav = $this->getVenda($id, $originAtual);
            }

            if (!$dav) {
                $this->error('DAV não encontrada');
                return;
            }

            $stmt = $this->db->prepare("
                UPDATE vendas
                SET modulo_origem = 'venda',
                    status_id = 2,
                    updated_at = NOW()
                WHERE id = :id AND company_id = :company_id AND modulo_origem = :modulo_origem
            ");

            $stmt->execute([
                'id' => $id,
                'company_id' => $this->getCompanyId(),
                'modulo_origem' => $originAtual
            ]);

            if ($stmt->rowCount() === 0) {
                $this->error('Não foi possível converter a DAV. Verifique o status atual e tente novamente.');
                return;
            }

            $this->logActivity('convert', 'vendas', $id, [
                'from' => $originAtual,
                'to' => 'venda'
            ]);

            $this->success('DAV convertida em venda com sucesso', [
                'redirect' => '/vendas/editar?id=' . $id
            ]);

        } catch (\Exception $e) {
            $this->error('Erro ao converter DAV: ' . $e->getMessage());
        }
    }
}