<?php

declare(strict_types=1);

namespace App\Controllers;

/**
 * Controller da Página Inicial
 *
 * @author Romildo Conegundes
 * @package Systhema
 */
class HomeController extends BaseController
{
    /**
     * Página inicial do sistema
     */
    public function index(): void
    {
        // Se já estiver autenticado como usuário normal, redireciona para o dashboard
        if ($this->session->isAuthenticated() && $this->session->get('user_type') !== 'revenda') {
            $this->redirect('dashboard');
            return;
        }

        // Se autenticado como revenda, redireciona para o painel de revendas
        if ($this->session->isAuthenticated() && $this->session->get('user_type') === 'revenda') {
            $this->redirect('revenda/dashboard');
            return;
        }

        // Redireciona direto para o login
        $this->redirect('/login');
    }

    /**
     * Exibe a landing page
     */
    private function showLandingPage(): void
    {
        ?>
                <!DOCTYPE html>
                <html lang="pt-BR">

                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>Systhema ERP - Gestão Empresarial Inteligente</title>

                    <!-- Bootstrap CSS -->
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

                    <!-- Bootstrap Icons -->
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css" rel="stylesheet">

                    <!-- Google Fonts -->
                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

                    <style>
                        * {
                            margin: 0;
                            padding: 0;
                            box-sizing: border-box;
                        }

                        :root {
                            --primary: #2563eb;
                            --primary-dark: #1e40af;
                            --secondary: #7c3aed;
                            --accent: #06b6d4;
                            --success: #10b981;
                            --bg-light: #f8fafc;
                            --bg-white: #ffffff;
                            --text-dark: #1e293b;
                            --text-gray: #475569;
                            --text-light: #64748b;
                            --border: #e2e8f0;
                        }

                        body {
                            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                            background-color: var(--bg-white);
                            color: var(--text-dark);
                            line-height: 1.6;
                            overflow-x: hidden;
                        }

                        /* Navbar */
                        .navbar {
                            background-color: #1e293b;
                            backdrop-filter: blur(10px);
                            padding: 1.25rem 0;
                            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
                            position: fixed;
                            width: 100%;
                            top: 0;
                            z-index: 1000;
                            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                        }

                        .navbar-brand {
                            font-size: 1.75rem;
                            font-weight: 700;
                            color: #ffffff !important;
                            letter-spacing: -0.5px;
                            display: flex;
                            align-items: center;
                            gap: 0.75rem;
                        }

                        .navbar-brand i {
                            color: var(--primary);
                            margin-right: 0.5rem;
                        }

                        .logo-image {
                            height: 90px;
                            width: auto;
                            object-fit: contain;
                            transform: scale(2);
                            transform-origin: left center;
                        }

                        .footer .logo-image {
                            height: 40px;
                        }

                        .nav-link {
                            color: rgba(255, 255, 255, 0.8) !important;
                            font-weight: 500;
                            margin: 0 1rem;
                            transition: color 0.3s;
                        }

                        .nav-link:hover {
                            color: #ffffff !important;
                        }

                        /* Hero Section */
                        .hero-section {
                            padding: 140px 0 100px;
                            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 50%, #ddd6fe 100%);
                            position: relative;
                        }

                        .hero-section::before {
                            content: '';
                            position: absolute;
                            top: 0;
                            left: 0;
                            right: 0;
                            bottom: 0;
                            background:
                                radial-gradient(circle at 20% 50%, rgba(37, 99, 235, 0.05) 0%, transparent 50%),
                                radial-gradient(circle at 80% 80%, rgba(124, 58, 237, 0.05) 0%, transparent 50%);
                            pointer-events: none;
                        }

                        .hero-content {
                            position: relative;
                            z-index: 1;
                        }

                        .hero-title {
                            font-size: 3.5rem;
                            font-weight: 700;
                            line-height: 1.2;
                            margin-bottom: 1.5rem;
                            letter-spacing: -1px;
                            color: var(--text-dark);
                        }

                        .hero-subtitle {
                            font-size: 1.35rem;
                            color: var(--text-gray);
                            font-weight: 400;
                            margin-bottom: 2.5rem;
                            max-width: 600px;
                        }

                        .btn-primary-custom {
                            background: var(--primary);
                            color: #ffffff;
                            padding: 0.95rem 2.5rem;
                            border-radius: 8px;
                            font-weight: 600;
                            font-size: 1rem;
                            border: none;
                            transition: all 0.3s;
                            text-decoration: none;
                            display: inline-block;
                            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.15);
                        }

                        .btn-primary-custom:hover {
                            background: var(--primary-dark);
                            color: #ffffff;
                            transform: translateY(-2px);
                            box-shadow: 0 8px 15px rgba(37, 99, 235, 0.25);
                        }

                        .btn-secondary-custom {
                            background: rgba(255, 255, 255, 0.1);
                            color: #ffffff;
                            padding: 0.95rem 2.5rem;
                            border-radius: 8px;
                            font-weight: 600;
                            font-size: 1rem;
                            border: 2px solid rgba(255, 255, 255, 0.3);
                            transition: all 0.3s;
                            text-decoration: none;
                            display: inline-block;
                        }

                        .btn-secondary-custom:hover {
                            border-color: #ffffff;
                            color: #ffffff;
                            background: rgba(255, 255, 255, 0.2);
                            transform: translateY(-2px);
                            box-shadow: 0 4px 10px rgba(255, 255, 255, 0.2);
                        }

                        /* Botão secundário para seções claras */
                        .hero-section .btn-secondary-custom,
                        .pricing-section .btn-secondary-custom {
                            background: #ffffff;
                            color: var(--primary);
                            border: 2px solid var(--primary);
                        }

                        .hero-section .btn-secondary-custom:hover,
                        .pricing-section .btn-secondary-custom:hover {
                            border-color: var(--primary-dark);
                            color: var(--primary-dark);
                            background: #f8fafc;
                            box-shadow: 0 4px 10px rgba(37, 99, 235, 0.1);
                        }

                        /* Stats Section */
                        .stats-section {
                            background: #ffffff;
                            padding: 4rem 0;
                            border-top: 1px solid var(--border);
                            border-bottom: 1px solid var(--border);
                        }

                        .stat-item {
                            text-align: center;
                            padding: 1.5rem;
                        }

                        .stat-number {
                            font-size: 2.75rem;
                            font-weight: 700;
                            color: var(--primary);
                            display: block;
                            margin-bottom: 0.5rem;
                        }

                        .stat-label {
                            font-size: 1rem;
                            color: var(--text-gray);
                            font-weight: 500;
                            text-transform: uppercase;
                            letter-spacing: 1px;
                        }

                        /* Features Section */
                        .features-section {
                            padding: 100px 0;
                            background: var(--bg-light);
                        }

                        .section-title {
                            font-size: 2.5rem;
                            font-weight: 700;
                            margin-bottom: 1rem;
                            text-align: center;
                            color: var(--text-dark);
                        }

                        .section-subtitle {
                            font-size: 1.15rem;
                            color: var(--text-gray);
                            text-align: center;
                            margin-bottom: 4rem;
                            max-width: 700px;
                            margin-left: auto;
                            margin-right: auto;
                        }

                        .feature-box {
                            background: #ffffff;
                            border: 1px solid var(--border);
                            border-radius: 16px;
                            padding: 2.5rem 2rem;
                            height: 100%;
                            transition: all 0.3s;
                            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
                        }

                        .feature-box:hover {
                            border-color: var(--primary);
                            transform: translateY(-8px);
                            box-shadow: 0 12px 24px rgba(37, 99, 235, 0.15);
                        }

                        .feature-icon {
                            width: 56px;
                            height: 56px;
                            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
                            border-radius: 12px;
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            margin-bottom: 1.5rem;
                        }

                        .feature-icon i {
                            font-size: 1.75rem;
                            color: #ffffff;
                        }

                        .feature-title {
                            font-size: 1.25rem;
                            font-weight: 600;
                            margin-bottom: 0.75rem;
                            color: var(--text-dark);
                        }

                        .feature-description {
                            color: var(--text-gray);
                            font-size: 0.95rem;
                            line-height: 1.6;
                        }

                        /* Pricing Section */
                        .pricing-section {
                            padding: 100px 0;
                            background: #ffffff;
                        }

                        .pricing-card {
                            background: #ffffff;
                            border: 2px solid var(--border);
                            border-radius: 16px;
                            padding: 2.5rem 2rem;
                            height: 100%;
                            position: relative;
                            transition: all 0.3s;
                        }

                        .pricing-card:hover {
                            border-color: var(--primary);
                            box-shadow: 0 12px 24px rgba(37, 99, 235, 0.15);
                            transform: translateY(-4px);
                        }

                        .pricing-card.featured {
                            border-color: var(--primary);
                            background: linear-gradient(135deg, #f0f9ff 0%, #ffffff 100%);
                            box-shadow: 0 8px 20px rgba(37, 99, 235, 0.2);
                        }

                        .pricing-badge {
                            position: absolute;
                            top: -12px;
                            right: 20px;
                            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
                            color: #ffffff;
                            padding: 0.4rem 1rem;
                            border-radius: 20px;
                            font-size: 0.75rem;
                            font-weight: 600;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                        }

                        .pricing-name {
                            font-size: 1.5rem;
                            font-weight: 600;
                            margin-bottom: 1rem;
                            color: var(--text-dark);
                        }

                        .pricing-price {
                            font-size: 3rem;
                            font-weight: 700;
                            color: var(--primary);
                            margin-bottom: 0.5rem;
                        }

                        .pricing-period {
                            color: var(--text-gray);
                            margin-bottom: 2rem;
                        }

                        .pricing-features {
                            list-style: none;
                            padding: 0;
                            margin-bottom: 2rem;
                        }

                        .pricing-features li {
                            padding: 0.75rem 0;
                            color: var(--text-gray);
                            display: flex;
                            align-items: center;
                        }

                        .pricing-features li i {
                            color: var(--success);
                            margin-right: 0.75rem;
                            font-size: 1.1rem;
                        }

                        /* Footer */
                        .footer {
                            background: var(--bg-light);
                            border-top: 1px solid var(--border);
                            padding: 3rem 0 2rem;
                        }

                        .footer-brand {
                            font-size: 1.35rem;
                            font-weight: 700;
                            margin-bottom: 1rem;
                            color: var(--text-dark);
                        }

                        .footer-text {
                            color: var(--text-gray);
                            font-size: 0.95rem;
                            margin-bottom: 0.5rem;
                        }

                        .footer-link {
                            color: var(--primary);
                            text-decoration: none;
                            transition: color 0.3s;
                        }

                        .footer-link:hover {
                            color: var(--primary-dark);
                            text-decoration: underline;
                        }

                        .footer-bottom {
                            margin-top: 2rem;
                            padding-top: 2rem;
                            border-top: 1px solid var(--border);
                            text-align: center;
                            color: var(--text-gray);
                            font-size: 0.9rem;
                        }

                        /* Animações suaves */
                        @keyframes fadeInUp {
                            from {
                                opacity: 0;
                                transform: translateY(20px);
                            }

                            to {
                                opacity: 1;
                                transform: translateY(0);
                            }
                        }

                        .hero-content {
                            animation: fadeInUp 0.8s ease-out;
                        }

                        .feature-box,
                        .pricing-card {
                            animation: fadeInUp 0.8s ease-out;
                            animation-fill-mode: both;
                        }

                        .feature-box:nth-child(1) {
                            animation-delay: 0.1s;
                        }

                        .feature-box:nth-child(2) {
                            animation-delay: 0.2s;
                        }

                        .feature-box:nth-child(3) {
                            animation-delay: 0.3s;
                        }

                        .feature-box:nth-child(4) {
                            animation-delay: 0.4s;
                        }

                        .feature-box:nth-child(5) {
                            animation-delay: 0.5s;
                        }

                        .feature-box:nth-child(6) {
                            animation-delay: 0.6s;
                        }

                        @media (max-width: 768px) {
                            .hero-title {
                                font-size: 2.5rem;
                            }

                            .hero-subtitle {
                                font-size: 1.15rem;
                            }

                            .section-title {
                                font-size: 2rem;
                            }

                            .pricing-card {
                                margin-bottom: 2rem;
                            }
                        }
                    </style>
                </head>

                <body>
                    <!-- Navbar -->
                    <nav class="navbar">
                        <div class="container">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <a class="navbar-brand" href="./">
                                    <img src="storage/uploads/logo.png" alt="Systhema" class="logo-image">
                                </a>
                                <div class="d-flex gap-3">
                                    <a href="./revenda/login" class="btn-secondary-custom">
                                        <i class="bi bi-box-arrow-in-right me-2"></i>Painel Revenda
                                    </a>
                                </div>
                            </div>
                        </div>
                    </nav>

                    <!-- Hero Section -->
                    <section class="hero-section">
                        <div class="container">
                            <div class="row align-items-center">
                                <div class="col-lg-7 hero-content">
                                    <h1 class="hero-title">Gestão Empresarial<br />Inteligente e Escalável</h1>
                                    <p class="hero-subtitle">
                                        Plataforma ERP multi-tenant desenvolvida para empresas que buscam eficiência,
                                        segurança e crescimento sustentável através da tecnologia.
                                    </p>
                                    <div class="d-flex gap-3 flex-wrap">
                                        <a href="register" class="btn-primary-custom">
                                            <i class="bi bi-rocket-takeoff me-2"></i>Iniciar Teste Gratuito
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Stats Section -->
                    <section class="stats-section">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-3 col-6">
                                    <div class="stat-item">
                                        <span class="stat-number">99.9%</span>
                                        <span class="stat-label">Uptime</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="stat-item">
                                        <span class="stat-number">ISO 27001</span>
                                        <span class="stat-label">Segurança</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="stat-item">
                                        <span class="stat-number">24/7</span>
                                        <span class="stat-label">Suporte</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-6">
                                    <div class="stat-item">
                                        <span class="stat-number">Cloud</span>
                                        <span class="stat-label">Infraestrutura</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Features Section -->
                    <section class="features-section">
                        <div class="container">
                            <h2 class="section-title">Soluções Corporativas Completas</h2>
                            <p class="section-subtitle">
                                Ferramentas profissionais integradas para otimizar todos os processos da sua organização
                            </p>

                            <div class="row g-4">
                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-shield-lock"></i>
                                        </div>
                                        <h3 class="feature-title">Arquitetura Multi-Tenant</h3>
                                        <p class="feature-description">
                                            Isolamento completo de dados com banco dedicado por cliente.
                                            Conformidade com LGPD e padrões internacionais de segurança.
                                        </p>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-receipt-cutoff"></i>
                                        </div>
                                        <h3 class="feature-title">NF-e Integrada</h3>
                                        <p class="feature-description">
                                            Emissão de Notas Fiscais Eletrônicas homologadas pela SEFAZ.
                                            Certificação digital A1 e comunicação segura com webservices.
                                        </p>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-graph-up-arrow"></i>
                                        </div>
                                        <h3 class="feature-title">Business Intelligence</h3>
                                        <p class="feature-description">
                                            Relatórios gerenciais avançados, dashboards analíticos e
                                            exportação em múltiplos formatos (PDF, Excel, CSV).
                                        </p>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-database"></i>
                                        </div>
                                        <h3 class="feature-title">Gestão Financeira</h3>
                                        <p class="feature-description">
                                            Contas a pagar e receber, fluxo de caixa projetado,
                                            conciliação bancária e integração com gateways de pagamento.
                                        </p>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-boxes"></i>
                                        </div>
                                        <h3 class="feature-title">Controle de Estoque</h3>
                                        <p class="feature-description">
                                            Movimentações em tempo real, inventários periódicos,
                                            múltiplos locais de armazenamento e rastreabilidade completa.
                                        </p>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="feature-box">
                                        <div class="feature-icon">
                                            <i class="bi bi-code-square"></i>
                                        </div>
                                        <h3 class="feature-title">API RESTful</h3>
                                        <p class="feature-description">
                                            API completa para integrações empresariais. Autenticação JWT,
                                            documentação OpenAPI e webhooks para automações.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Pricing Section -->
                    <section class="pricing-section">
                        <div class="container">
                            <h2 class="section-title">Planos Empresariais</h2>
                            <p class="section-subtitle">
                                Escolha o plano adequado ao porte e necessidades da sua organização
                            </p>

                            <div class="row g-4">
                                <div class="col-md-4">
                                    <div class="pricing-card">
                                        <div class="pricing-name">Avaliação</div>
                                        <div class="pricing-price">72 horas</div>
                                        <div class="pricing-period">gratuito</div>
                                        <ul class="pricing-features">
                                            <li><i class="bi bi-check-circle-fill"></i> Até 2 usuários</li>
                                            <li><i class="bi bi-check-circle-fill"></i> 1 CNPJ</li>
                                            <li><i class="bi bi-check-circle-fill"></i> 5 notas fiscais</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Todos os recursos</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Suporte por e-mail</li>
                                        </ul>
                                        <a href="register?plan=trial" class="btn-secondary-custom w-100">Iniciar Avaliação</a>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="pricing-card featured">
                                        <div class="pricing-badge">Mais Escolhido</div>
                                        <div class="pricing-name">Profissional</div>
                                        <div class="pricing-price">R$ 199,99</div>
                                        <div class="pricing-period">por mês</div>
                                        <ul class="pricing-features">
                                            <li><i class="bi bi-check-circle-fill"></i> Até 5 usuários</li>
                                            <li><i class="bi bi-check-circle-fill"></i> 2 empresas (CNPJs)</li>
                                            <li><i class="bi bi-check-circle-fill"></i> NF-e ilimitadas</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Relatórios avançados</li>
                                            <li><i class="bi bi-check-circle-fill"></i> API RESTful</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Integrações</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Suporte prioritário</li>
                                        </ul>
                                        <a href="register?plan=pro" class="btn-primary-custom w-100">Assinar Agora</a>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="pricing-card">
                                        <div class="pricing-name">Enterprise</div>
                                        <div class="pricing-price">A partir de<br>R$ 499,99</div>
                                        <div class="pricing-period">por mês</div>
                                        <ul class="pricing-features">
                                            <li><i class="bi bi-check-circle-fill"></i> Usuários ilimitados</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Empresas ilimitadas</li>
                                            <li><i class="bi bi-check-circle-fill"></i> NF-e ilimitadas</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Relatórios customizados</li>
                                            <li><i class="bi bi-check-circle-fill"></i> API + Webhooks</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Gerente dedicado</li>
                                            <li><i class="bi bi-check-circle-fill"></i> SLA garantido</li>
                                            <li><i class="bi bi-check-circle-fill"></i> Infraestrutura dedicada</li>
                                        </ul>
                                        <a href="register?plan=enterprise" class="btn-secondary-custom w-100">Contatar Vendas</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Footer -->
                    <footer class="footer">
                        <div class="container">
                            <div class="row">
                                <div class="col-md-4 mb-4">
                                    <div class="footer-brand" style="display: flex; align-items: center; gap: 0.75rem;">
                                        <img src="storage/uploads/logo.png" alt="Systhema" class="logo-image">
                                        <span>Systhema</span>
                                    </div>
                                    <p class="footer-text">
                                        Soluções empresariais de alto desempenho para gestão completa do seu negócio.
                                    </p>
                                </div>

                                <div class="col-md-4 mb-4">
                                    <h5 class="mb-3" style="font-weight: 600; color: var(--text-dark);">Empresa</h5>
                                    <p class="footer-text mb-1">Systhema Software Solutions</p>
                                    <p class="footer-text mb-1">CNPJ: XX.XXX.XXX/XXXX-XX</p>
                                    <p class="footer-text">São Paulo - SP, Brasil</p>
                                </div>

                                <div class="col-md-4 mb-4">
                                    <h5 class="mb-3" style="font-weight: 600; color: var(--text-dark);">Contato</h5>
                                    <p class="footer-text">
                                        <i class="bi bi-envelope me-2"></i>
                                        <a href="mailto:romildo@Systhema.com.br" class="footer-link">romildo@Systhema.com.br</a>
                                    </p>
                                    <p class="footer-text">
                                        <i class="bi bi-github me-2"></i>
                                        <a href="https://github.com/CodeConegundes" target="_blank"
                                            class="footer-link">@CodeConegundes</a>
                                    </p>
                                    <p class="footer-text mt-3">
                                        <strong style="color: var(--text-dark);">Romildo Conegundes</strong><br>
                                        <span style="color: var(--text-gray); font-size: 0.9rem;">Chief Executive Officer</span>
                                    </p>
                                </div>
                            </div>

                            <div class="footer-bottom">
                                <p class="mb-0" style="color: var(--text-gray);">
                                    © 2025 Systhema. Todos os direitos reservados. Licença Proprietária.
                                </p>
                                <p class="mb-0 mt-1" style="font-size: 0.85rem; color: var(--text-light);">
                                    Desenvolvido com tecnologia PHP 8.2 | Arquitetura Multi-tenant | Conformidade LGPD
                                </p>
                            </div>
                        </div>
                    </footer>

                    <!-- Bootstrap JS -->
                    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
                </body>

                </html>
                <?php
    }
}