<?php

namespace App\Controllers;

class ErrorController extends BaseController
{
    /**
     * Exibe página de erro 404
     */
    public function notFound(): void
    {
        $this->view('errors/404', [
            'pageTitle' => 'Página não encontrada',
            'activeMenu' => null
        ], 404);
    }

    /**
     * Exibe página de erro 403
     */
    public function forbidden(): void
    {
        $this->view('errors/403', [
            'pageTitle' => 'Acesso negado',
            'activeMenu' => null
        ], 403);
    }

    /**
     * Exibe página de erro 500
     */
    public function serverError(string $message = null): void
    {
        $this->view('errors/500', [
            'pageTitle' => 'Erro interno do servidor',
            'message' => $message,
            'activeMenu' => null
        ], 500);
    }

    /**
     * Exibe página de erro genérica
     * Sobrescreve o método do BaseController para exibir página HTML ao invés de JSON
     */
    public function error(string $message, array $errors = [], int $statusCode = 400): void
    {
        $view = 'errors/error';
        $data = [
            'pageTitle' => 'Erro',
            'message' => !empty($message) ? $message : 'Ocorreu um erro inesperado',
            'errors' => $errors,
            'statusCode' => $statusCode,
            'activeMenu' => null
        ];

        // Usar view específica se existir
        if ($statusCode === 404) {
            $view = 'errors/404';
        } elseif ($statusCode === 403) {
            $view = 'errors/403';
        } elseif ($statusCode >= 500) {
            $view = 'errors/500';
        }

        $this->view($view, $data, $statusCode);
    }

    /**
     * Sobrescreve o método view para definir o status code HTTP
     */
    protected function view(string $view, array $data = [], int $statusCode = 200): void
    {
        http_response_code($statusCode);
        parent::view($view, $data);
    }
}
