#!/bin/bash

# Script para criar subdomínio manualmente
# Usado quando HOSTING_PANEL=manual

SUBDOMAIN=$1
BASE_DOMAIN="Systhema.com.br"
DOCUMENT_ROOT="/public_html"

if [ -z "$SUBDOMAIN" ]; then
    echo "Erro: Subdomínio não informado"
    exit 1
fi

# Exemplo para Apache (ajuste conforme seu servidor)
# Cria arquivo de virtual host
VHOST_FILE="/etc/apache2/sites-available/${SUBDOMAIN}.${BASE_DOMAIN}.conf"

cat > "$VHOST_FILE" <<EOF
<VirtualHost *:80>
    ServerName ${SUBDOMAIN}.${BASE_DOMAIN}
    DocumentRoot ${DOCUMENT_ROOT}/${SUBDOMAIN}

    <Directory ${DOCUMENT_ROOT}/${SUBDOMAIN}>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>

<VirtualHost *:443>
    ServerName ${SUBDOMAIN}.${BASE_DOMAIN}
    DocumentRoot ${DOCUMENT_ROOT}/${SUBDOMAIN}

    SSLEngine on
    SSLCertificateFile /etc/ssl/certs/${BASE_DOMAIN}.crt
    SSLCertificateKeyFile /etc/ssl/private/${BASE_DOMAIN}.key

    <Directory ${DOCUMENT_ROOT}/${SUBDOMAIN}>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
EOF

# Ativa o site
a2ensite "${SUBDOMAIN}.${BASE_DOMAIN}.conf"

# Reinicia Apache
systemctl reload apache2

echo "success: Subdomínio ${SUBDOMAIN}.${BASE_DOMAIN} criado"

