<?php
/**
 * Rotas API
 */

use App\Core\Router;

// Router é passado pela Application
if (!isset($router)) {
    return;
}

// Prefixo /api para todas as rotas
$router->group('/api', function($router) {

    // Autenticação API
    $router->post('/auth/login', 'Api\AuthController@login');
    $router->post('/auth/refresh', 'Api\AuthController@refresh');

    // Rotas protegidas por token JWT
    $router->group('/v1', function($router) {

        // Pessoas
        // $router->get('/pessoas', 'Api\PessoasController@index');
        // $router->get('/pessoas/{id}', 'Api\PessoasController@show');
        // $router->post('/pessoas', 'Api\PessoasController@store');
        // $router->put('/pessoas/{id}', 'Api\PessoasController@update');
        // $router->delete('/pessoas/{id}', 'Api\PessoasController@delete');

        // Itens
        // $router->get('/itens', 'Api\ItensController@index');
        // $router->get('/itens/{id}', 'Api\ItensController@show');
        // $router->post('/itens', 'Api\ItensController@store');
        // $router->put('/itens/{id}', 'Api\ItensController@update');
        // $router->delete('/itens/{id}', 'Api\ItensController@delete');

        // Vendas
        // $router->get('/vendas', 'Api\VendasController@index');
        // $router->get('/vendas/{id}', 'Api\VendasController@show');
        // $router->post('/vendas', 'Api\VendasController@store');

        // Compras
        // $router->get('/compras', 'Api\ComprasController@index');
        // $router->get('/compras/{id}', 'Api\ComprasController@show');
        // $router->post('/compras', 'Api\ComprasController@store');

        // Estoque
        // $router->get('/estoque', 'Api\EstoqueController@index');
        // $router->get('/estoque/{id}', 'Api\EstoqueController@show');

        // Financeiro
        // $router->get('/entradas', 'Api\EntradasController@index');
        // $router->get('/saidas', 'Api\SaidasController@index');
        // $router->get('/fluxo-caixa', 'Api\FluxoCaixaController@index');

    }, ['ApiAuthMiddleware']);

}, []);

// Webhooks (sem autenticação, mas com validação de assinatura)
$router->post('/webhook/asaas', 'WebhookController@asaas');
$router->post('/webhook/stripe', 'WebhookController@stripe');

