<?php
/**
 * Script temporário para visualizar logs de debug de produtos
 * Remover após uso
 */

$logDir = __DIR__ . '/../storage/logs';
$logFile = $logDir . '/produtos_debug_' . date('Y-m-d') . '.log';

header('Content-Type: text/plain; charset=utf-8');

if (file_exists($logFile)) {
    echo "=== Logs de hoje (" . date('Y-m-d') . ") ===\n\n";
    $lines = file($logFile);
    $recentLines = array_slice($lines, -100); // Últimas 100 linhas
    echo implode('', $recentLines);
} else {
    echo "Arquivo de log não encontrado: " . $logFile . "\n";
    echo "\n=== Listando todos os logs disponíveis ===\n\n";
    if (is_dir($logDir)) {
        $files = glob($logDir . '/produtos_debug_*.log');
        if (empty($files)) {
            echo "Nenhum arquivo de log encontrado.\n";
            echo "Os logs serão criados quando você acessar a página de edição do produto.\n";
        } else {
            foreach ($files as $file) {
                echo basename($file) . " - " . date('Y-m-d H:i:s', filemtime($file)) . "\n";
            }
        }
    } else {
        echo "Diretório de logs não existe: " . $logDir . "\n";
    }
}
