<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Helpers\InadimplenciaHelper;
use App\Core\Session;

// Iniciar sessão
Session::start();

// Verificar se usuário está logado
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Não autorizado']);
    exit;
}

// Verificar método HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método não permitido']);
    exit;
}

// Obter dados da requisição
$input = json_decode(file_get_contents('php://input'), true);
$clienteId = $input['cliente_id'] ?? null;
$companyId = $_SESSION['company_id'] ?? null;

if (!$clienteId) {
    http_response_code(400);
    echo json_encode(['error' => 'ID do cliente é obrigatório']);
    exit;
}

try {
    // Verificar inadimplência universal
    $resultado = InadimplenciaHelper::verificarInadimplenciaUniversal($clienteId, $companyId);

    // Preparar resposta
    $response = [
        'success' => true,
        'inadimplente' => $resultado['inadimplente'],
        'pode_operar' => !$resultado['inadimplente'],
        'status' => InadimplenciaHelper::getStatusInadimplencia($clienteId, $companyId)
    ];

    if ($resultado['inadimplente']) {
        $response['mensagem'] = InadimplenciaHelper::getMensagemBloqueio($resultado);
        $response['motivo'] = $resultado['motivo'] ?? 'Inadimplência detectada';

        if (isset($resultado['empresa'])) {
            $response['empresa_origem'] = $resultado['empresa'];
        }
    }

    echo json_encode($response);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Erro interno do servidor',
        'message' => $e->getMessage()
    ]);
}
