/**
 * Máscaras para o módulo de Impostos
 * Formata NCM, CEST e valores monetários em tempo real
 */

// Inicializa as máscaras quando o documento estiver pronto
function initImpostosMasks() {
    // Máscara para valores monetários
    if (typeof $.fn.mask !== 'undefined') {
        $('.mascara-moeda').mask('#.##0,00', { reverse: true });
    }

    // Máscara para NCM (0000.00.00) - formata ao digitar
    $(document).on('input', '.mascara-ncm', function () {
        let valor = $(this).val().replace(/\D/g, '');
        if (valor.length > 0) {
            // Limita a 8 dígitos
            valor = valor.slice(0, 8);
            // Formata automaticamente
            if (valor.length > 6) {
                valor = valor.slice(0, 4) + '.' + valor.slice(4, 6) + '.' + valor.slice(6);
            } else if (valor.length > 4) {
                valor = valor.slice(0, 4) + '.' + valor.slice(4);
            }
        }
        $(this).val(valor);
    });

    // Máscara para CEST (00.000.00) - formata ao digitar
    $(document).on('input', '.mascara-cest', function () {
        let valor = $(this).val().replace(/\D/g, '');
        if (valor.length > 0) {
            // Limita a 7 dígitos
            valor = valor.slice(0, 7);
            // Formata automaticamente
            if (valor.length > 5) {
                valor = valor.slice(0, 2) + '.' + valor.slice(2, 5) + '.' + valor.slice(5);
            } else if (valor.length > 2) {
                valor = valor.slice(0, 2) + '.' + valor.slice(2);
            }
        }
        $(this).val(valor);
    });

    // Inicializa valores padrão para máscaras monetárias
    $('.mascara-moeda').each(function () {
        if (!$(this).val()) {
            $(this).val('0,00');
        }
    });
}

// Função para converter valor da máscara para formato do banco
function converterParaBanco(valor) {
    if (!valor || valor === '0,00') return '0.00';
    return valor.replace(/\./g, '').replace(',', '.');
}

// Função para preparar formulário antes de enviar
function prepararFormularioImpostos(formId) {
    $(formId).on('submit', function () {
        // Converter valores monetários para formato do banco
        $('.mascara-moeda').each(function () {
            $(this).val(converterParaBanco($(this).val()));
        });

        // Remove pontos do NCM e CEST antes de enviar
        $('#ncm').val($('#ncm').val().replace(/\./g, ''));
        $('#cest').val($('#cest').val().replace(/\./g, ''));
    });
}

// Auto-inicializa quando o documento estiver pronto
if (typeof jQuery !== 'undefined') {
    $(document).ready(function () {
        initImpostosMasks();
    });
}

