<?php
try {
    $pdo = new PDO('mysql:host=localhost;dbname=Systhema', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "Verificando tabela vendas_itens...\n";

    // Verificar se a tabela vendas_itens existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'vendas_itens'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Tabela vendas_itens não existe! Criando...\n";

        // Criar tabela vendas_itens básica
        $sql = "CREATE TABLE IF NOT EXISTS `vendas_itens` (
            `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            `company_id` INT UNSIGNED NOT NULL,
            `venda_id` INT UNSIGNED NOT NULL COMMENT 'ID da venda',
            `product_id` INT UNSIGNED NULL COMMENT 'ID do produto',
            `product_name` VARCHAR(255) NOT NULL COMMENT 'Nome do produto (snapshot)',
            `product_sku` VARCHAR(50) NULL COMMENT 'SKU do produto',
            `quantity` DECIMAL(10,3) NOT NULL DEFAULT 1.000 COMMENT 'Quantidade',
            `unit_price` DECIMAL(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Preço unitário',
            `discount` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Desconto no item',
            `discount_type` ENUM('fixed', 'percent') DEFAULT 'fixed',
            `total_price` DECIMAL(15,2) NOT NULL DEFAULT 0.00 COMMENT 'Total do item',
            `notes` VARCHAR(500) NULL COMMENT 'Observações do item',
            `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX `idx_company` (`company_id`),
            INDEX `idx_venda` (`venda_id`),
            INDEX `idx_product` (`product_id`),
            FOREIGN KEY (`venda_id`) REFERENCES `vendas`(`id`) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

        $pdo->exec($sql);
        echo "✅ Tabela vendas_itens criada!\n";
    } else {
        echo "✅ Tabela vendas_itens já existe!\n";
    }

    // Verificar se as colunas de impostos existem
    $stmt = $pdo->query("SHOW COLUMNS FROM vendas_itens LIKE 'base_calculo_icms'");
    if ($stmt->rowCount() == 0) {
        echo "❌ Colunas de impostos não existem! Adicionando...\n";

        // Adicionar colunas de impostos uma por vez
        $columns = [
            "ADD COLUMN `ncm` VARCHAR(20) NULL COMMENT 'NCM do produto' AFTER `notes`",
            "ADD COLUMN `cest` VARCHAR(20) NULL COMMENT 'CEST do produto' AFTER `ncm`",
            "ADD COLUMN `cfop` VARCHAR(4) NULL COMMENT 'CFOP da operação' AFTER `cest`",
            "ADD COLUMN `origem` VARCHAR(1) NULL COMMENT 'Origem da mercadoria' AFTER `cfop`",
            "ADD COLUMN `cst_icms` VARCHAR(3) NULL COMMENT 'CST/CSOSN ICMS' AFTER `origem`",
            "ADD COLUMN `aliquota_icms` DECIMAL(5,2) DEFAULT 0.00 COMMENT 'Alíquota ICMS (%)' AFTER `cst_icms`",
            "ADD COLUMN `valor_icms` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Valor ICMS calculado' AFTER `aliquota_icms`",
            "ADD COLUMN `base_calculo_icms` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Base de cálculo ICMS' AFTER `valor_icms`",
            "ADD COLUMN `cst_pis` VARCHAR(2) NULL COMMENT 'CST PIS' AFTER `base_calculo_icms`",
            "ADD COLUMN `aliquota_pis` DECIMAL(5,2) DEFAULT 0.00 COMMENT 'Alíquota PIS (%)' AFTER `cst_pis`",
            "ADD COLUMN `valor_pis` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Valor PIS calculado' AFTER `aliquota_pis`",
            "ADD COLUMN `base_calculo_pis` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Base de cálculo PIS' AFTER `valor_pis`",
            "ADD COLUMN `cst_cofins` VARCHAR(2) NULL COMMENT 'CST COFINS' AFTER `base_calculo_pis`",
            "ADD COLUMN `aliquota_cofins` DECIMAL(5,2) DEFAULT 0.00 COMMENT 'Alíquota COFINS (%)' AFTER `cst_cofins`",
            "ADD COLUMN `valor_cofins` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Valor COFINS calculado' AFTER `aliquota_cofins`",
            "ADD COLUMN `base_calculo_cofins` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Base de cálculo COFINS' AFTER `valor_cofins`",
            "ADD COLUMN `cst_ipi` VARCHAR(2) NULL COMMENT 'CST IPI' AFTER `base_calculo_cofins`",
            "ADD COLUMN `aliquota_ipi` DECIMAL(5,2) DEFAULT 0.00 COMMENT 'Alíquota IPI (%)' AFTER `cst_ipi`",
            "ADD COLUMN `valor_ipi` DECIMAL(15,2) DEFAULT 0.00 COMMENT 'Valor IPI calculado' AFTER `aliquota_ipi`",
            "ADD COLUMN `origem_st` VARCHAR(1) NULL COMMENT 'Origem ST' AFTER `valor_ipi`"
        ];

        foreach ($columns as $column) {
            try {
                $sql = "ALTER TABLE `vendas_itens` " . $column;
                $pdo->exec($sql);
                echo "✅ Coluna adicionada: " . substr($column, 13, 20) . "...\n";
            } catch (Exception $e) {
                echo "⚠️ Erro ao adicionar coluna: " . $e->getMessage() . "\n";
            }
        }

        echo "✅ Colunas de impostos adicionadas!\n";
    } else {
        echo "✅ Colunas de impostos já existem!\n";
    }

    // Verificar estrutura final
    $stmt = $pdo->query('DESCRIBE vendas_itens');
    echo "\nEstrutura da tabela vendas_itens:\n";
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "- {$row['Field']} ({$row['Type']})\n";
    }

} catch (Exception $e) {
    echo "Erro: " . $e->getMessage() . "\n";
}
?>