# Script PowerShell para adicionar subdomínio ao arquivo hosts
# Execute como ADMINISTRADOR!
# Uso: .\adicionar_subdominio.ps1 -Subdomain "novosubdominio"

param(
    [Parameter(Mandatory=$true)]
    [string]$Subdomain
)

$hostsPath = "C:\Windows\System32\drivers\etc\hosts"
$domain = "Systhema.local"
$entry = "127.0.0.1 $Subdomain.$domain"

# Verifica se já existe
$hostsContent = Get-Content $hostsPath
if ($hostsContent -contains $entry) {
    Write-Host "✅ Subdomínio $Subdomain.$domain já existe no hosts!" -ForegroundColor Green
    exit 0
}

# Adiciona nova entrada
Add-Content -Path $hostsPath -Value $entry
Write-Host "✅ Subdomínio adicionado com sucesso!" -ForegroundColor Green
Write-Host "   $entry" -ForegroundColor Cyan
Write-Host ""
Write-Host "Agora você pode acessar: http://$Subdomain.$domain" -ForegroundColor Yellow

