# 🔔 Webhook Banco Inter - Recebimento Automático de Pagamentos

## 📋 O que é?

O webhook permite que o **Banco Inter notifique automaticamente** o sistema quando:
- ✅ Boleto for **pago**
- ❌ Boleto for **cancelado**
- ⏰ Boleto **expirar**
- 📝 Qualquer mudança de status

---

## 🚀 Como Configurar

### **1. URL do Webhook**

Configure esta URL no painel do Banco Inter:

```
https://printjetdigital.localhost/webhook/banco-inter
```

⚠️ **IMPORTANTE:**
- Em **produção**, substitua por seu domínio real: `https://seudominio.com/webhook/banco-inter`
- O Banco Inter **precisa conseguir acessar** esta URL (não pode ser localhost em produção)

---

### **2. Configurar no Painel do Banco Inter**

1. Acesse: [https://empresas.bancointer.com.br/](https://empresas.bancointer.com.br/)
2. Faça login
3. Vá em: **Cobrança** → **Configurações** → **Webhooks**
4. Clique em **"Adicionar Webhook"**
5. Preencha:
   - **URL:** `https://printjetdigital.localhost/webhook/banco-inter`
   - **Eventos:** Selecione:
     - ✅ `cobranca.paga` (Quando boleto é pago)
     - ✅ `cobranca.cancelada` (Quando boleto é cancelado)
     - ✅ `cobranca.expirada` (Quando boleto expira)
6. Clique em **"Salvar"**

---

### **3. Validar Configuração**

O Banco Inter vai enviar uma notificação de teste. Verifique os logs:

**Windows PowerShell:**
```powershell
Get-Content C:\xampp\apache\logs\error.log -Tail 50 | Select-String -Pattern "Webhook Banco Inter"
```

Deve aparecer:
```
Webhook Banco Inter - Notificação recebida
```

---

## 🔄 Fluxo Automático de Pagamento

Quando o cliente **pagar o boleto**:

1. 🏦 **Banco Inter** detecta o pagamento
2. 📡 **Envia webhook** para o sistema
3. ✅ Sistema **atualiza a conta a receber**:
   - Marca como **PAGA**
   - Atualiza `amount_received`
   - Registra `payment_date`
4. 💰 **Gera lançamento no Fluxo de Caixa** automaticamente
5. 📊 **Dashboard atualizado** em tempo real

**Tudo automático, sem intervenção manual!** 🎉

---

## 🧪 Testar Webhook (Simulação)

Para testar sem esperar um pagamento real, use:

```bash
curl -X POST http://printjetdigital.localhost/webhook/banco-inter \
  -H "Content-Type: application/json" \
  -d '{
    "nossoNumero": "90488647895",
    "seuNumero": "0000000019",
    "situacao": "PAGO",
    "valorPago": 5.00,
    "dataHoraSituacao": "2025-11-04T15:30:00"
  }'
```

**Verificar resultado:**
- Acesse a conta #19 em Contas a Receber
- Deve estar marcada como **PAGA**
- Deve ter lançamento no **Fluxo de Caixa**

---

## 📝 Logs

Todos os webhooks são registrados em:
- `C:\xampp\apache\logs\error.log` (Windows)
- `/var/log/apache2/error.log` (Linux)

Procure por: `Webhook Banco Inter`

---

## ⚠️ Importante

### **Segurança:**
- O webhook é **público** (sem autenticação)
- Valide sempre os dados recebidos
- Em produção, considere validar o IP de origem (IPs do Banco Inter)

### **Performance:**
- O webhook deve responder **rapidamente** (< 5 segundos)
- Processamento pesado deve ser feito em background

### **Retry:**
- Se o webhook retornar erro, o Banco Inter **tentará novamente**
- Certifique-se de que o processamento é **idempotente**

---

## 🆘 Troubleshooting

### **Webhook não está sendo recebido:**
1. Verifique se a URL está acessível publicamente
2. Teste a URL manualmente (cURL)
3. Verifique os logs do Apache
4. Confirme que a rota está registrada em `routes/web.php`

### **Pagamento não está sendo processado:**
1. Verifique os logs: procure por "Webhook Banco Inter"
2. Confirme que tem um status "pago" configurado no módulo
3. Verifique se o `nossoNumero` ou `seuNumero` está correto

---

## 📚 Referências

- [Documentação Oficial - Webhooks Banco Inter](https://developers.bancointer.com.br/reference/webhooks)
- [API de Cobrança v3](https://developers.bancointer.com.br/reference/cobrancas)

