# 🌐 Automação de Subdomínios - Systhema SaaS

## 📋 Visão Geral

O sistema **automatiza a criação de subdomínios** quando um novo tenant é registrado. Isso permite que cada cliente tenha seu próprio subdomínio automaticamente:

```
https://cliente1.Systhema.com.br
https://cliente2.Systhema.com.br
https://printjetdigital.Systhema.com.br
```

---

## 🚀 Métodos de Criação

### **1. Wildcard DNS (RECOMENDADO - Mais Simples)** ⭐

**Como funciona:**
- Configura um DNS wildcard (`*.Systhema.com.br`) apontando para o servidor
- O Apache/VirtualHost já está configurado para aceitar qualquer subdomínio
- **Não precisa criar nada no servidor**, apenas garantir que o DNS está OK

**Configuração:**

1. **No painel DNS** (onde você gerencia o domínio Systhema.com.br):
   - Adicione um registro A:
     ```
     Tipo: A
     Host: *
     Valor: IP_DO_SERVIDOR
     ```
   - Ou CNAME:
     ```
     Tipo: CNAME
     Host: *
     Valor: Systhema.com.br
     ```

2. **No Apache** (VirtualHost):
   ```apache
   <VirtualHost *:80>
       ServerName *.Systhema.com.br
       ServerAlias *.Systhema.com.br
       DocumentRoot /public_html/Systhema

       <Directory /public_html/Systhema>
           AllowOverride All
           Require all granted
       </Directory>
   </VirtualHost>
   ```

3. **No `.env`:**
   ```env
   HOSTING_PANEL=wildcard
   BASE_DOMAIN=Systhema.com.br
   ```

**Vantagens:**
- ✅ Zero configuração no servidor
- ✅ Funciona instantaneamente
- ✅ Não precisa de API
- ✅ Suporta SSL wildcard

---

### **2. cPanel API**

**Quando usar:**
- Se você usa cPanel e quer controle granular
- Se precisa criar diretórios específicos por subdomínio

**Configuração:**

1. **Gerar API Token no cPanel:**
   - Acesse: `cPanel → Segurança → API Tokens`
   - Clique em "Criar"
   - Copie o token gerado

2. **No `.env`:**
   ```env
   HOSTING_PANEL=cpanel
   BASE_DOMAIN=Systhema.com.br
   CPANEL_API_URL=https://Systhema.com.br:2083
   CPANEL_API_USER=seu_usuario
   CPANEL_API_TOKEN=seu_token_aqui
   DOCUMENT_ROOT=/public_html
   ```

**Vantagens:**
- ✅ Cria diretórios automaticamente
- ✅ Integração completa com cPanel
- ⚠️ Requer API token

---

### **3. Script Manual (SSH)**

**Quando usar:**
- Se você tem acesso SSH ao servidor
- Se quer controle total sobre o processo

**Configuração:**

1. **No `.env`:**
   ```env
   HOSTING_PANEL=manual
   BASE_DOMAIN=Systhema.com.br
   DOCUMENT_ROOT=/public_html
   ```

2. **Dar permissão ao script:**
   ```bash
   chmod +x scripts/create_subdomain.sh
   ```

3. **Ajustar o script** (`scripts/create_subdomain.sh`) conforme seu servidor

**Vantagens:**
- ✅ Controle total
- ✅ Pode personalizar completamente
- ⚠️ Requer acesso SSH

---

## 📝 Configuração no `.env`

Adicione estas variáveis ao seu arquivo `.env`:

```env
# Tipo de painel (wildcard, cpanel, plesk, directadmin, manual)
HOSTING_PANEL=wildcard

# Domínio base
BASE_DOMAIN=Systhema.com.br

# Configurações do cPanel (se usar)
CPANEL_API_URL=https://Systhema.com.br:2083
CPANEL_API_USER=seu_usuario
CPANEL_API_TOKEN=seu_token_aqui

# Diretório raiz (para alguns métodos)
DOCUMENT_ROOT=/public_html
```

---

## 🧪 Testar

### **1. Criar um novo tenant:**
```bash
# Via interface web
Acesse: https://Systhema.com.br/register
Informe subdomínio: "teste"
```

### **2. Verificar logs:**
```bash
tail -f /var/log/apache2/error.log | grep SubdomainManager
```

Deve aparecer:
```
SubdomainManager - Criando subdomínio: teste
SubdomainManager - Wildcard: Subdomínio teste disponível em https://teste.Systhema.com.br
```

### **3. Testar acesso:**
```
https://teste.Systhema.com.br
```

---

## 🔧 Troubleshooting

### **Subdomínio não funciona:**

1. **Verificar DNS:**
   ```bash
   dig *.Systhema.com.br
   # Deve retornar o IP do servidor
   ```

2. **Verificar Apache:**
   ```bash
   apache2ctl -S
   # Verificar se o VirtualHost está configurado
   ```

3. **Verificar logs:**
   ```bash
   tail -f /var/log/apache2/error.log
   ```

### **Erro "Subdomínio já existe":**

- O sistema verifica se o subdomínio já está registrado no banco
- Se estiver, você precisa escolher outro nome

### **Erro de permissão (método manual):**

```bash
# Dar permissão ao script
chmod +x scripts/create_subdomain.sh

# Verificar se o usuário tem permissão para criar virtual hosts
sudo usermod -aG www-data seu_usuario
```

---

## 📚 Referências

- [cPanel API Documentation](https://api.docs.cpanel.net/)
- [Apache VirtualHost Documentation](https://httpd.apache.org/docs/current/vhosts/)
- [Wildcard DNS Setup](https://www.cloudflare.com/learning/dns/dns-records/dns-wildcard/)

---

## ✅ Checklist de Configuração

- [ ] DNS wildcard configurado (`*.Systhema.com.br`)
- [ ] Apache VirtualHost configurado para aceitar wildcard
- [ ] Variáveis do `.env` configuradas
- [ ] Testar criação de tenant
- [ ] Verificar logs
- [ ] Testar acesso ao subdomínio criado
- [ ] Configurar SSL wildcard (Let's Encrypt)

---

## 🎯 Próximos Passos

1. **SSL Wildcard:** Configurar certificado SSL para todos os subdomínios
2. **Monitoramento:** Criar dashboard para monitorar subdomínios criados
3. **Limpeza:** Implementar remoção automática de subdomínios inativos

