# Integração Shipay - Systhema ERP

## Visão Geral

A integração com a Shipay permite gerar cobranças via **Pix** e **Boleto Híbrido** (Pix + Boleto) diretamente pelo sistema.

---

## Credenciais de Homologação (Sandbox)

Para testes em ambiente sandbox, a Shipay fornece uma conta de teste padrão:

```env
SHIPAY_ACCESS_KEY=shipay-pagador
SHIPAY_SECRET_KEY=shipay-pagador
SHIPAY_CLIENT_ID=shipay-pagador
SHIPAY_ENVIRONMENT=sandbox
```

**URL Sandbox:** `https://api-staging.shipay.com.br`

---

## Credenciais de Produção

Para produção, acesse o **Painel Shipay** e obtenha suas credenciais:

1. Acesse: https://portal.shipay.com.br
2. Vá em **Configurações > API**
3. Copie o `access_key`, `secret_key` e `client_id`
4. Configure no `.env`:

```env
SHIPAY_ACCESS_KEY=sua_access_key_real
SHIPAY_SECRET_KEY=sua_secret_key_real
SHIPAY_CLIENT_ID=seu_client_id_real
SHIPAY_ENVIRONMENT=production
```

---

## Configuração de Wallet (Carteira)

A Shipay exige que você configure uma **wallet** (carteira de pagamento) no painel para definir o tipo de cobrança:

### Tipos de Wallet:
- **Pix:** Pagamentos instantâneos
- **Boleto Híbrido:** Pix + Boleto (BB, Bradesco, Itaú, Sicoob)

### Como configurar:
1. Acesse o Painel Shipay
2. Vá em **Configurações > Wallets**
3. Adicione a wallet desejada para sua loja
4. A API usará automaticamente a wallet configurada

---

## Endpoints Utilizados

| Endpoint | Método | Descrição |
|----------|--------|-----------|
| `/pdvauth` | POST | Autenticação (obtém token) |
| `/order` | POST | Criar cobrança (Pix/Boleto) |
| `/order/{id}` | GET | Consultar cobrança |
| `/order/{id}` | DELETE | Cancelar cobrança |

---

## Webhook

Configure o webhook para receber notificações de pagamento:

```env
SHIPAY_WEBHOOK_URL=https://seudominio.com.br/webhook/shipay
SHIPAY_WEBHOOK_SECRET=sua_chave_secreta
```

### Eventos recebidos:
- `approved` - Pagamento aprovado
- `pending` - Aguardando pagamento
- `cancelled` - Cobrança cancelada
- `expired` - Cobrança expirada

---

## Fluxo de Integração

```
1. Usuário cria cobrança no Systhema
       ↓
2. Sistema chama POST /order na Shipay
       ↓
3. Shipay retorna QR Code Pix / Linha digitável
       ↓
4. Cliente paga via app do banco
       ↓
5. Shipay envia webhook com status "approved"
       ↓
6. Sistema atualiza status da conta para "Pago"
```

---

## Arquivos Relacionados

- `src/Integrations/ShipayClient.php` - Cliente HTTP para API Shipay
- `src/Controllers/ShipayWebhookController.php` - Processa webhooks
- `src/Controllers/EntradasController.php` - Gera boletos para Contas a Receber
- `config/payment.php` - Configurações dos gateways

---

## Migrations Necessárias

Execute as migrations para adicionar campos da Shipay:

```sql
-- Tabela contas_receber
source database/migration_add_shipay_columns_contas_receber.sql

-- Tabela empresas (config por empresa)
source database/migration_add_shipay_columns_empresas.sql
```

---

## Documentação Oficial

- **API Reference:** https://shipay.readme.io/reference
- **Painel:** https://portal.shipay.com.br
- **Suporte:** suporte@shipay.com.br

---

## Troubleshooting

### Erro: "The wallet None is not accepted"
→ Configure uma wallet no Painel Shipay para sua loja.

### Erro: "No wallet settings set for this store"
→ A loja não tem wallet configurada. Acesse o painel e adicione uma.

### Resposta HTML ao invés de JSON
→ Verifique se a URL base está correta (`api-staging` para sandbox, `api` para produção).

### Token expirado
→ O sistema reautentica automaticamente. Se persistir, verifique as credenciais.

