# ⚡ Setup Rápido - Systhema Multi-tenant

## 📋 Passo 1: Configurar Apache VirtualHost

### Edite o arquivo:
`C:\xampp\apache\conf\extra\httpd-vhosts.conf`

### Cole no final do arquivo:
```apache
<VirtualHost *:80>
    ServerName Systhema.local
    ServerAlias *.Systhema.local
    DocumentRoot "C:/xampp/htdocs/Systhema"

    <Directory "C:/xampp/htdocs/Systhema">
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

---

## 📋 Passo 2: Habilitar módulos no Apache

### Edite: `C:\xampp\apache\conf\httpd.conf`

### Descomente estas linhas (remova o #):

```apache
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule vhost_alias_module modules/mod_vhost_alias.so
Include conf/extra/httpd-vhosts.conf
```

---

## 📋 Passo 3: Configurar arquivo hosts

### Abra COMO ADMINISTRADOR:
`C:\Windows\System32\drivers\etc\hosts`

### Adicione no final:
```
127.0.0.1 Systhema.local
127.0.0.1 gaelsystem.Systhema.local
127.0.0.1 conegundes.Systhema.local
127.0.0.1 conegundes1.Systhema.local
127.0.0.1 conegundes2.Systhema.local
```

**IMPORTANTE:** Adicione uma linha para cada subdomínio que criar!

---

## 📋 Passo 4: Atualizar .env (SE AINDA NÃO FEZ)

Copie `env.example.txt` para `.env` e edite:

```env
BASE_DOMAIN=Systhema.local
```

---

## 📋 Passo 5: Reiniciar Apache

No XAMPP Control Panel:
1. Stop Apache
2. Start Apache

---

## ✅ Testar

Acesse:
- **http://Systhema.local/** - Landing page
- **http://Systhema.local/register** - Registro
- **http://gaelsystem.Systhema.local/login** - Login do tenant

---

## 🎯 Como Funciona

Quando você cria uma conta com subdomínio `minhaempresa`:

1. Sistema cria banco: `Systhema_tenant_minhaempresa`
2. Redireciona para: `http://minhaempresa.Systhema.local/login`
3. Login identifica o tenant pelo subdomínio
4. Conecta automaticamente ao banco correto

---

## 🆘 Problemas?

**Erro: Não abre nada**
- Verifique se adicionou todas as linhas no hosts
- Use .local no final (não .com)

**Erro: Página em branco**
- Verifique logs: `C:\xampp\apache\logs\error.log`

**Wildcard não funciona**
- Adicione CADA subdomínio manualmente no hosts
- Windows não suporta wildcard DNS local nativamente

---

Desenvolvido por Romildo Conegundes
CEO - Systhema

