# Systhema ERP SaaS

Sistema ERP Multi-tenant desenvolvido em PHP 8.2 com arquitetura MVC e PSR-4.

**Autor:** Romildo Conegundes
**GitHub:** [@CodeConegundes](https://github.com/CodeConegundes)
**Empresa:** Systhema
**Cargo:** CEO
**Email:** romildo@Systhema.com.br
**Licença:** Proprietária

## 🚀 Características

- **Multi-tenant**: Cada cliente possui seu próprio banco de dados
- **Multi-empresa**: Múltiplas empresas dentro de cada tenant
- **Sistema de Assinaturas**: Planos Free, Pro e Enterprise
- **Gateways de Pagamento**: Integração com Asaas e Stripe
- **Permissões Granulares**: Controle detalhado por módulo e ação
- **2FA Parametrizável**: Autenticação de dois fatores opcional
- **API RESTful**: API completa com autenticação JWT
- **Responsive**: Interface responsiva com template Upzet

## 📋 Requisitos

- PHP 8.2 ou superior
- MySQL 5.7 ou superior
- Composer
- Extensões PHP: PDO, mbstring, json

## 🔧 Instalação

1. Clone o repositório:
```bash
git clone https://github.com/seu-usuario/Systhema.git
cd Systhema
```

2. Instale as dependências:
```bash
composer install
```

3. Configure o ambiente:
```bash
cp env.example.txt .env
```

Edite o arquivo `.env` com suas configurações de banco de dados e outras variáveis.

4. Crie o banco de dados master:
```bash
mysql -u root -p < database/master_schema.sql
```

5. Configure o servidor web para apontar para a pasta `public` ou use o servidor embutido:
```bash
php -S localhost:8000
```

6. Acesse o sistema:
```
http://localhost:8000
```

## 📁 Estrutura do Projeto

```
Systhema/
├── config/                 # Arquivos de configuração
│   ├── app.php
│   ├── database.php
│   ├── mail.php
│   └── payment.php
├── database/              # Schemas SQL
│   ├── master_schema.sql
│   ├── tenant_schema.sql
│   └── tenant_schema_part2.sql
├── public/                # Arquivos públicos (CSS, JS, imagens)
├── routes/                # Definição de rotas
│   ├── web.php
│   └── api.php
├── src/                   # Código-fonte (PSR-4)
│   ├── Controllers/
│   ├── Core/
│   ├── Helpers/
│   ├── Middleware/
│   ├── Models/
│   └── Services/
├── storage/               # Armazenamento (logs, cache, uploads)
│   ├── cache/
│   ├── logs/
│   ├── sessions/
│   └── uploads/
├── views/                 # Templates/Views
│   ├── auth/
│   ├── dashboard/
│   └── layouts/
├── .htaccess             # Configuração Apache
├── composer.json
├── index.php             # Entry point
└── README.md
```

## 🔐 Autenticação

O sistema suporta autenticação web tradicional e autenticação via API com JWT.

### Login Web
```
POST /login
{
    "email": "usuario@exemplo.com",
    "password": "senha123"
}
```

### Login API
```
POST /api/auth/login
{
    "email": "usuario@exemplo.com",
    "password": "senha123"
}
```

## 📊 Módulos do Sistema

### Registros
- Pessoas (Clientes, Fornecedores, Funcionários)
- Grupos
- Contas Bancárias
- Métodos de Pagamento
- Gestor de Estoque (Locais)
- Itens/Produtos
- Plano de Contas

### Operacional
- Compras
- Vendas
- Gestão de Estoque
- Ordem de Serviço
- Agenda

### Financeiro
- Contas a Receber (Entradas)
- Contas a Pagar (Saídas)
- Fluxo de Caixa

### Gestão
- Usuários
- Relatórios
- Parâmetros

## 🔌 API

A API RESTful está disponível no prefixo `/api/v1`. Exemplos:

```bash
# Listar pessoas
GET /api/v1/pessoas
Authorization: Bearer {token}

# Criar item
POST /api/v1/itens
Authorization: Bearer {token}
{
    "name": "Produto X",
    "code": "PROD001",
    "sale_price": 99.90
}
```

## 🎨 Template

O sistema utiliza o template Upzet (responsivo e moderno) com tema escuro por padrão.

## 📝 Planos de Assinatura

### Free
- 2 usuários
- 1 empresa
- 100 MB armazenamento
- 20 notas fiscais/mês
- Relatórios básicos

### Pro
- 10 usuários
- 3 empresas
- 1 GB armazenamento
- 500 notas fiscais/mês
- Relatórios avançados
- Acesso à API
- Suporte prioritário

### Enterprise
- Usuários ilimitados
- Empresas ilimitadas
- 10 GB armazenamento
- Notas fiscais ilimitadas
- Relatórios personalizados
- Acesso à API
- Suporte prioritário
- Gerente dedicado
- Integrações personalizadas

## 🔒 Segurança

- Senhas criptografadas com bcrypt
- Proteção contra SQL Injection (PDO com prepared statements)
- Proteção contra XSS
- CSRF protection
- Autenticação JWT para API
- Logs de atividades
- Permissões granulares

## 🤝 Contribuindo

Contribuições são bem-vindas! Por favor, abra uma issue primeiro para discutir as mudanças propostas.

## 📄 Licença

Este projeto está sob licença proprietária. Todos os direitos reservados.

Copyright © 2025 Systhema. Desenvolvido por Romildo Conegundes.

Para informações sobre licenciamento, entre em contato: romildo@Systhema.com.br

## 👥 Suporte e Contato

**Email:** romildo@Systhema.com.br
**Suporte:** suporte@Systhema.com.br
**Website:** https://Systhema.com.br
**GitHub:** https://github.com/CodeConegundes

---

**Desenvolvido com ❤️ por Romildo Conegundes**
© 2025 Systhema. Todos os direitos reservados.

