# 📋 Módulo de Parâmetros - Systhema ERP

**Desenvolvido por:** Romildo Conegundes
**Empresa:** Systhema
**Última atualização:** 13 de Outubro de 2025

---

## 🎯 Visão Geral

O módulo de Parâmetros centraliza todas as configurações do sistema em uma interface amigável e organizada por categorias.

---

## 📂 Categorias de Parâmetros

### 1. ⚙️ Geral
Configurações básicas da empresa e personalização

**Campos:**
- Nome da Empresa
- Slogan
- Telefone (com máscara automática)
- Email
- Logo da Empresa (upload)
- Cor Primária (color picker)
- Cor Secundária (color picker)
- Fuso Horário

### 2. ✉️ Email
Configurações do servidor SMTP para envio de emails

**Campos:**
- Host SMTP (ex: smtp.gmail.com)
- Porta (587 ou 465)
- Criptografia (TLS/SSL)
- Usuário/Email
- Senha
- Nome do Remetente
- Email do Remetente

**Recursos:**
- Botão "Testar Email" para verificar configuração

### 3. 📄 NFe
Configurações para Nota Fiscal Eletrônica

**Campos:**
- Ambiente (Homologação/Produção)
- Série NFe
- Certificado Digital (upload .pfx ou .p12)
- Senha do Certificado

**Requisitos:**
- Certificado A1 (arquivo .pfx ou .p12)
- Senha do certificado
- Integração com sped-nfe

### 4. 🧮 Fiscal
Parâmetros fiscais e tributários

**Campos:**
- Regime Tributário (Simples/Real/Presumido)
- Percentual ICMS (%)
- Percentual IPI (%)
- CFOP Padrão (Venda)
- NCM Padrão
- CST Padrão

### 5. 🔒 Segurança
Configurações de segurança do sistema

**Opções:**
- ✅ Autenticação de Dois Fatores (2FA)
- Tempo de Sessão (minutos)
- Tentativas Máximas de Login
- ✅ Forçar Troca de Senha Periódica (90 dias)
- ✅ Log de Auditoria

### 6. ⭐ Assinatura
Informações sobre o plano contratado

**Exibe:**
- Plano atual
- Status da assinatura
- Valor mensal
- Data de vencimento
- Recursos incluídos
- Botões de ação (Upgrade, Gerenciar)

---

## 🗄️ Estrutura do Banco de Dados

### Tabela: `system_parameters`

```sql
CREATE TABLE `system_parameters` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `category` VARCHAR(50) NOT NULL,
    `name` VARCHAR(100) NOT NULL,
    `value` TEXT NULL,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `unique_param` (`category`, `name`),
    INDEX `idx_category` (`category`)
);
```

### Parâmetros Padrão

```sql
-- Geral
('geral', 'nome_empresa', 'Minha Empresa')
('geral', 'slogan', 'Seu slogan aqui')
('geral', 'cor_primaria', '#0066CC')
('geral', 'cor_secundaria', '#2c6eb4')
('geral', 'timezone', 'America/Sao_Paulo')

-- Email
('email', 'smtp_host', 'smtp.gmail.com')
('email', 'smtp_port', '587')
('email', 'smtp_encryption', 'tls')

-- NFe
('nfe', 'nfe_ambiente', 'homologacao')
('nfe', 'nfe_serie', '1')

-- Fiscal
('fiscal', 'regime_tributario', 'simples')
('fiscal', 'icms_padrao', '18,00')
('fiscal', 'ipi_padrao', '0,00')
('fiscal', 'cfop_venda', '5102')
('fiscal', 'cst_padrao', '00')

-- Segurança
('seguranca', 'enable_2fa', '0')
('seguranca', 'session_timeout', '60')
('seguranca', 'max_login_attempts', '5')
('seguranca', 'force_password_change', '0')
('seguranca', 'enable_audit_log', '1')
```

---

## 📁 Arquivos do Módulo

### Backend
- **`src/Controllers/ParametrosController.php`** - Controller principal
- **`parametros.php`** - Acesso direto (lista)
- **`parametros-salvar.php`** - Salvar parâmetros
- **`parametros-upload.php`** - Upload de arquivos

### Frontend
- **`views/parametros/index.php`** - Interface principal com tabs

### Banco de Dados
- **`database/tenant_schema.sql`** - Schema com tabela
- **`database/migration_add_parameters.sql`** - Migração

### Documentação
- **`PARAMETROS.md`** - Este arquivo

---

## 🚀 Como Usar

### Acessar Parâmetros

```
http://seu-dominio.local/parametros.php
```

Ou pelo menu lateral:
```
Gestão → Parâmetros
```

### Salvar Configurações

1. Navegue até a aba desejada
2. Preencha os campos
3. Clique em "Salvar Configurações [Categoria]"
4. Aguarde confirmação (Toast de sucesso)

### Upload de Arquivos

**Logo da Empresa:**
- Formatos: JPG, PNG, GIF
- Tamanho máximo: 2MB
- Seleção automática via input file
- Upload instantâneo ao selecionar

**Certificado Digital:**
- Formatos: .pfx, .p12
- Tamanho máximo: 5MB
- Necessário para emissão de NFe
- Upload seguro com senha

---

## 🔌 API Endpoints

### GET `/parametros`
Lista todos os parâmetros organizados por categoria

**Resposta:**
```php
[
    'parametros' => [
        'geral' => [
            'nome_empresa' => 'Systhema',
            'slogan' => 'ERP Inteligente'
        ],
        'email' => [...]
    ],
    'assinatura' => [
        'plan_name' => 'Pro',
        'status' => 'active'
    ]
]
```

### POST `/parametros/save`
Salva parâmetros de uma categoria

**Payload:**
```javascript
{
    categoria: 'geral',
    parametros: {
        nome_empresa: 'Minha Empresa',
        slogan: 'Meu Slogan',
        telefone: '(11) 98765-4321'
    }
}
```

### POST `/parametros/upload`
Faz upload de arquivos (logo ou certificado)

**Payload:**
```javascript
{
    tipo: 'logo', // ou 'certificado'
    arquivo: [FILE]
}
```

---

## 💡 Recursos Avançados

### 1. Teste de Email
```javascript
function testarEmail() {
    Swal.fire({
        title: 'Email de Teste',
        input: 'email',
        inputLabel: 'Digite o email de destino:'
    }).then((result) => {
        // Envia email de teste
    });
}
```

### 2. Validação de Campos
- Telefone: Máscara automática `(00) 00000-0000`
- Quantidade/Percentual: Máscara `0,000`
- Email: Validação HTML5 + JavaScript

### 3. Persistência
- Salva automaticamente via AJAX
- Sem reload de página
- Feedback visual instantâneo (Toast)

### 4. Segurança
- Upload sanitizado
- Validação de extensões
- Limite de tamanho de arquivo
- Nomes únicos gerados automaticamente

---

## 🎨 Interface

### Layout
- **Tabs Bootstrap 5** para organização
- **Cards** para agrupamento lógico
- **Form switches** para opções booleanas
- **Color pickers** para personalização
- **File inputs** para uploads

### Cores
- Primária: `#0066CC`
- Secundária: `#2c6eb4`
- Sucesso: `#28a745`
- Perigo: `#dc3545`

---

## 🛠️ Migração

### Para bancos existentes:

```bash
mysql -u root SEU_BANCO < database/migration_add_parameters.sql
```

### Via phpMyAdmin:
1. Selecione o banco tenant
2. Vá em SQL
3. Cole o conteúdo de `migration_add_parameters.sql`
4. Execute

---

## 📊 Exemplo de Uso no Código

### Ler parâmetro
```php
// No Controller
$stmt = $this->db->prepare("
    SELECT value FROM system_parameters
    WHERE category = ? AND name = ?
");
$stmt->execute(['geral', 'nome_empresa']);
$nomeEmpresa = $stmt->fetchColumn();
```

### Salvar parâmetro
```php
$stmt = $this->db->prepare("
    INSERT INTO system_parameters (category, name, value)
    VALUES (?, ?, ?)
    ON DUPLICATE KEY UPDATE value = ?, updated_at = NOW()
");
$stmt->execute(['geral', 'nome_empresa', $valor, $valor]);
```

### Buscar todos de uma categoria
```php
$stmt = $this->db->prepare("
    SELECT name, value FROM system_parameters
    WHERE category = ?
");
$stmt->execute(['email']);
$emailParams = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
```

---

## ✅ Checklist de Implementação

- [x] Criar tabela `system_parameters`
- [x] Criar Controller `ParametrosController`
- [x] Criar View com 6 tabs
- [x] Implementar upload de logo
- [x] Implementar upload de certificado
- [x] Adicionar máscaras nos campos
- [x] Integrar com sistema de Toast
- [x] Criar rotas
- [x] Criar arquivos de acesso direto
- [x] Adicionar ao menu lateral
- [x] Criar migração SQL
- [x] Documentação completa

---

## 🔄 Próximas Melhorias

- [ ] Teste real de envio de email
- [ ] Validação de certificado digital
- [ ] Histórico de alterações
- [ ] Import/Export de configurações
- [ ] Backup automático de parâmetros
- [ ] Templates de configuração por segmento
- [ ] API para integração externa

---

**Desenvolvido com ❤️ pela equipe Systhema**
**Autor:** Romildo Conegundes (romildo@Systhema.com.br)
**Licença:** Proprietário

