# Módulo Ordem de Serviço PMOC

## Descrição

O módulo de Ordem de Serviço PMOC permite criar e gerenciar ordens de serviço relacionadas a PMOC (Plano de Manutenção, Operação e Controle) para ar condicionados.

## Funcionalidades

### 1. Gestão de Ordens de Serviço PMOC
- Criação de ordens de serviço vinculadas a PMOC
- Edição de ordens de serviço existentes
- Visualização detalhada de ordens de serviço
- Impressão de ordens de serviço
- Exclusão de ordens de serviço

### 2. Integração com PMOC
- Vinculação de ordem de serviço a PMOC existente
- Criação automática de novo PMOC ao criar ordem de serviço
- Visualização de dados do PMOC na ordem de serviço
- Listagem de equipamentos do PMOC

### 3. Gestão de Itens
- Adição de múltiplos itens (produtos/serviços) à ordem
- Cálculo automático de totais
- Aplicação de descontos

## Instalação

### 1. Executar Script SQL

Execute o script SQL para criar as tabelas necessárias:

```bash
mysql -u root -p nome_do_banco < database/CREATE_ordem_servico_pmoc.sql
```

Ou execute diretamente no MySQL:

```sql
SOURCE database/CREATE_ordem_servico_pmoc.sql;
```

### 2. Verificar Rotas

As rotas já foram adicionadas ao arquivo `routes/web.php`:

- `GET /ordem-servico-pmoc` - Listagem de ordens
- `GET /ordem-servico-pmoc/criar` - Formulário de criação
- `POST /ordem-servico-pmoc/criar` - Criar ordem
- `GET /ordem-servico-pmoc/editar` - Formulário de edição
- `POST /ordem-servico-pmoc/editar` - Atualizar ordem
- `GET /ordem-servico-pmoc/visualizar` - Visualizar ordem
- `GET /ordem-servico-pmoc/imprimir` - Imprimir ordem
- `POST /ordem-servico-pmoc/deletar` - Excluir ordem

## Estrutura de Dados

### Tabela: ordem_servico_pmoc
Vincula uma ordem de serviço (venda) a um PMOC.

- `venda_id` - ID da venda (ordem de serviço)
- `pmoc_id` - ID do PMOC
- `company_id` - ID da empresa

### Tabela: pmoc
Armazena os dados do PMOC.

- `numero_pmoc` - Número único do PMOC (formato: PMOC/ANO/XXXX)
- `data_emissao` - Data de emissão
- `data_validade` - Data de validade
- `cliente_id` - ID do cliente
- `responsavel_tecnico` - Nome do responsável técnico
- `crea_cau` - Número do CREA/CAU

### Tabela: pmoc_equipamentos
Armazena os equipamentos de ar condicionado do PMOC.

- `pmoc_id` - ID do PMOC
- `tipo_equipamento` - Tipo do equipamento
- `marca` - Marca
- `modelo` - Modelo
- `capacidade` - Capacidade (BTU)
- `local_instalacao` - Local de instalação

## Uso

### Criar Nova Ordem de Serviço PMOC

1. Acesse `/ordem-servico-pmoc/criar`
2. Preencha os dados da ordem de serviço
3. Selecione um PMOC existente ou marque "Criar novo PMOC"
4. Se criar novo PMOC, preencha os dados do PMOC
5. Adicione os itens da ordem de serviço
6. Clique em "Salvar"

### Editar Ordem de Serviço PMOC

1. Acesse a listagem de ordens
2. Clique no botão "Editar" da ordem desejada
3. Faça as alterações necessárias
4. Clique em "Atualizar"

### Visualizar Ordem de Serviço PMOC

1. Acesse a listagem de ordens
2. Clique no botão "Visualizar" da ordem desejada
3. Visualize todos os detalhes da ordem, incluindo dados do PMOC e equipamentos

### Imprimir Ordem de Serviço PMOC

1. Acesse a visualização da ordem
2. Clique no botão "Imprimir"
3. A ordem será aberta em uma nova aba para impressão

## Formato de Numeração

As ordens de serviço PMOC seguem o formato:
- `OS-PMOC/ANO/XXXX`
- Exemplo: `OS-PMOC/2024/0001`

## Observações

- O módulo utiliza a tabela `vendas` com `modulo_origem = 'os_pmoc'` para armazenar as ordens de serviço
- Os itens são armazenados na tabela `vendas_itens`
- O vínculo com PMOC é feito através da tabela `ordem_servico_pmoc`
- É possível criar um novo PMOC diretamente ao criar a ordem de serviço

## Dependências

- Tabela `vendas` (já existente)
- Tabela `vendas_itens` (já existente)
- Tabela `pessoas` (clientes)
- Tabela `produtos` (itens)
- Tabela `users` (vendedores)
- Tabela `metodos_pagamento`
- Tabela `companies`

## Autor

Systhema ERP SaaS
