# 🚀 Guia de Instalação - Módulo de Gestão de Impostos

## 📋 Resumo

Este guia orienta a instalação completa do módulo de **Gestão de Impostos** no sistema Systhema ERP.

---

## ✅ Pré-requisitos

- Sistema Systhema ERP instalado e funcionando
- Acesso ao banco de dados MySQL/MariaDB
- Acesso ao phpMyAdmin ou MySQL Workbench
- Permissões de administrador no sistema

---

## 📦 O que foi criado

### 1. **Backend (PHP)**
- ✅ `src/Controllers/ImpostosController.php` - Controller completo
- ✅ Rotas adicionadas em `routes/web.php`

### 2. **Frontend (Views)**
- ✅ `views/impostos/index.php` - Listagem
- ✅ `views/impostos/create.php` - Criar novo
- ✅ `views/impostos/edit.php` - Editar
- ✅ `views/impostos/form.php` - Formulário compartilhado

### 3. **Menu**
- ✅ Item adicionado no menu lateral (Registros → Gestão de Impostos)

### 4. **Banco de Dados**
- ✅ `database/migration_create_impostos_table.sql` - Estrutura da tabela
- ✅ `database/seed_impostos_exemplo.sql` - Dados de exemplo (opcional)

### 5. **Documentação**
- ✅ `database/README_IMPOSTOS.md` - Documentação completa do módulo
- ✅ `docs/MODULO_IMPOSTOS_INSTALACAO.md` - Este arquivo

---

## 🔧 Passo a Passo da Instalação

### **PASSO 1: Criar a Tabela no Banco de Dados**

#### Opção A: Via phpMyAdmin

1. Acesse o phpMyAdmin
2. Selecione o banco de dados do seu tenant
   - Exemplo: `Systhema_tenant_master` ou `Systhema_tenant_minhaempresa`
3. Clique na aba **SQL**
4. Abra o arquivo `Systhema/database/migration_create_impostos_table.sql`
5. Copie todo o conteúdo
6. Cole no editor SQL do phpMyAdmin
7. Clique em **Executar**
8. ✅ Verifique se aparece a mensagem de sucesso

#### Opção B: Via MySQL Workbench

1. Abra o MySQL Workbench
2. Conecte-se ao seu servidor MySQL
3. Abra o arquivo `migration_create_impostos_table.sql`
4. Execute o script (Ctrl+Shift+Enter)
5. ✅ Verifique se a tabela foi criada

#### Opção C: Via Linha de Comando

```bash
cd C:\xampp\htdocs\Systhema
mysql -u root -p Systhema_tenant_master < database/migration_create_impostos_table.sql
```

### **PASSO 2: (Opcional) Importar Dados de Exemplo**

Se desejar popular a tabela com impostos padrão brasileiros:

1. Abra o arquivo `database/seed_impostos_exemplo.sql`
2. **IMPORTANTE**: Altere a linha `SET @company_id = 1;` para o ID da sua empresa
3. Execute o arquivo no banco de dados (mesmo processo do Passo 1)
4. ✅ Verifique se os impostos foram inseridos

### **PASSO 3: Verificar a Instalação**

1. Faça login no sistema Systhema
2. No menu lateral, expanda **Registros**
3. Clique em **Gestão de Impostos**
4. ✅ Você deve ver a tela de listagem de impostos

### **PASSO 4: Testar o Módulo**

1. Clique em **+ Novo Imposto**
2. Preencha os campos obrigatórios:
   - Nome: `ICMS Teste`
   - Código: `ICMS`
   - Tipo: `ICMS`
   - Cálculo: `Percentual`
   - Alíquota: `18.00`
   - Aplica-se a: `Produtos`
   - Esfera: ☑️ Estadual
3. Marque **Ativo**
4. Clique em **Salvar Imposto**
5. ✅ O imposto deve aparecer na listagem

---

## 🎯 Funcionalidades Disponíveis

### ✅ CRUD Completo
- [x] Criar novo imposto
- [x] Listar impostos
- [x] Editar imposto
- [x] Excluir imposto

### ✅ Recursos Avançados
- [x] Filtros por tipo, esfera e status
- [x] Busca por nome ou código
- [x] Validação de exclusão (impede excluir impostos vinculados)
- [x] SweetAlert2 para notificações
- [x] Interface responsiva
- [x] Multi-tenancy (isolamento por empresa)

### ✅ Tipos de Impostos Suportados
- [x] ICMS (Estadual)
- [x] IPI (Federal)
- [x] PIS (Federal)
- [x] COFINS (Federal)
- [x] ISS (Municipal)
- [x] CSLL (Federal)
- [x] IRPJ (Federal)
- [x] Outros

### ✅ Configurações Fiscais
- [x] CFOP (Código Fiscal de Operações)
- [x] NCM (Nomenclatura Comum do Mercosul)
- [x] CST ICMS, PIS, COFINS
- [x] Impostos por dentro/fora
- [x] Impostos cumulativos

---

## 📊 Estrutura da Tabela

```sql
CREATE TABLE `impostos` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `company_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `code` varchar(50) NOT NULL,
  `type` enum('icms','ipi','pis','cofins','iss','csll','irpj','outros'),
  `calculation_type` enum('percentage','fixed'),
  `rate` decimal(10,4) NOT NULL DEFAULT 0.0000,
  `fixed_amount` decimal(15,2) NULL,
  `description` text NULL,
  `applies_to` enum('produtos','servicos','ambos'),
  `is_included_price` tinyint(1) DEFAULT 0,
  `is_cumulative` tinyint(1) DEFAULT 0,
  `is_federal` tinyint(1) DEFAULT 0,
  `is_state` tinyint(1) DEFAULT 0,
  `is_municipal` tinyint(1) DEFAULT 0,
  `cfop` varchar(4) NULL,
  `ncm` varchar(8) NULL,
  `cst_icms` varchar(3) NULL,
  `cst_pis` varchar(2) NULL,
  `cst_cofins` varchar(2) NULL,
  `sort_order` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
);
```

---

## 🔗 Rotas Criadas

| Método | Rota | Ação |
|--------|------|------|
| GET | `/impostos` | Listar impostos |
| GET | `/impostos/criar` | Formulário de criação |
| POST | `/impostos/criar` | Salvar novo imposto |
| GET | `/impostos/editar?id=X` | Formulário de edição |
| POST | `/impostos/editar` | Atualizar imposto |
| POST | `/impostos/deletar` | Excluir imposto |

---

## 🐛 Solução de Problemas

### Erro: "Table 'impostos' doesn't exist"
**Solução**: Execute a migration (Passo 1)

### Menu não aparece
**Solução**: Limpe o cache do navegador (Ctrl+Shift+Del)

### Página em branco
**Solução**: Verifique os logs em `storage/logs/`

### Erro ao salvar imposto
**Solução**: Verifique se todos os campos obrigatórios foram preenchidos

### Erro 404 ao acessar /impostos
**Solução**: Verifique se as rotas foram adicionadas em `routes/web.php`

---

## 📝 Próximos Passos

Após a instalação, você pode:

1. ✅ Cadastrar os impostos da sua empresa
2. ✅ Configurar as alíquotas conforme seu regime tributário
3. ✅ Vincular os impostos aos produtos/serviços
4. ✅ Usar os impostos nas vendas e notas fiscais

---

## 🔒 Segurança

O módulo possui:

- ✅ Autenticação obrigatória (middleware)
- ✅ Isolamento multi-tenant (por empresa)
- ✅ Validação de dados no backend
- ✅ Proteção contra SQL Injection (PDO)
- ✅ Sanitização de HTML nas views
- ✅ Log de atividades

---

## 📞 Suporte

Para dúvidas ou problemas:

1. Consulte a documentação completa em `database/README_IMPOSTOS.md`
2. Verifique os logs em `storage/logs/`
3. Entre em contato com o suporte técnico

---

## ✅ Checklist de Instalação

- [ ] Executei a migration `migration_create_impostos_table.sql`
- [ ] Verifiquei que a tabela `impostos` foi criada
- [ ] (Opcional) Importei os dados de exemplo
- [ ] Acessei o módulo via menu (Registros → Gestão de Impostos)
- [ ] Criei um imposto de teste
- [ ] O imposto apareceu na listagem
- [ ] Editei o imposto de teste
- [ ] As alterações foram salvas
- [ ] (Opcional) Excluí o imposto de teste
- [ ] ✅ **Módulo instalado e funcionando!**

---

**Desenvolvido por**: Systhema ERP
**Versão**: 1.0.0
**Data**: Janeiro 2025
**Status**: ✅ Pronto para produção

