# 🗺️ Migração: Campos de Endereço

## 📋 O que foi adicionado

Adicionamos 3 novos campos na tabela `companies` para armazenar endereços completos:

- **numero**: Número do logradouro (ex: "123", "S/N")
- **complemento**: Sala, andar, bloco (ex: "Sala 305")
- **bairro**: Bairro/Distrito (ex: "Centro")

---

## 🔧 Como atualizar seu banco de dados

### Opção 1: Via MySQL Workbench
1. Abra o MySQL Workbench
2. Conecte ao servidor local
3. Para CADA banco tenant (ex: `Systhema_tenant_asdfasdf`), execute:

```sql
USE Systhema_tenant_asdfasdf;

ALTER TABLE companies
ADD COLUMN numero VARCHAR(20) NULL AFTER address,
ADD COLUMN complemento VARCHAR(100) NULL AFTER numero,
ADD COLUMN bairro VARCHAR(100) NULL AFTER complemento;
```

### Opção 2: Via Linha de Comando
```bash
cd C:\xampp\mysql\bin
mysql -u root Systhema_tenant_SEU_TENANT < C:\xampp\htdocs\Systhema\database\migration_add_address_fields.sql
```

### Opção 3: Via phpMyAdmin
1. Acesse: http://localhost/phpmyadmin
2. Selecione o banco tenant (ex: `Systhema_tenant_asdfasdf`)
3. Vá em SQL
4. Cole e execute:

```sql
ALTER TABLE companies
ADD COLUMN numero VARCHAR(20) NULL AFTER address,
ADD COLUMN complemento VARCHAR(100) NULL AFTER numero,
ADD COLUMN bairro VARCHAR(100) NULL AFTER complemento;
```

---

## ✅ Novos recursos ativados

Após a migração, o formulário de empresas terá:

✅ **Campo Número** - Número do endereço
✅ **Campo Complemento** - Informações extras
✅ **Campo Bairro** - Auto-preenchido pela API ViaCEP

### Integração com API ViaCEP
Quando você digitar um CEP válido, o sistema agora preenche automaticamente:
- Logradouro (Rua, Avenida...)
- **Bairro** (novo!)
- Cidade
- UF

### Integração com API CNPJ
Quando buscar por CNPJ, também preenche:
- Endereço completo
- **Número** (quando disponível)
- **Complemento** (quando disponível)
- **Bairro** (quando disponível)

---

## 🔍 Verificar se a migração funcionou

Execute no MySQL:
```sql
DESCRIBE companies;
```

Você deve ver as colunas:
- `numero` - varchar(20)
- `complemento` - varchar(100)
- `bairro` - varchar(100)

---

**Desenvolvido por:** Romildo Conegundes
**Empresa:** Systhema
**Licença:** Proprietário

