# 📱 Menu Sidebar - Comportamento e Persistência

**Desenvolvido por:** Romildo Conegundes
**Empresa:** Systhema
**Última atualização:** 13 de Outubro de 2025

---

## 🎯 Comportamento Padrão

### Estado Inicial
✅ **TODOS os grupos de menu começam RECOLHIDOS** (padrão)

Os grupos são:
- 📋 Registros
- ⚙️ Operacional
- 💰 Financeiro
- 🏢 Gestão

---

## 🔄 Persistência de Estado

### Como funciona:
1. ✅ **Padrão:** Todos recolhidos ao carregar a página
2. 🖱️ **Ao clicar:** Menu expande/recolhe
3. 💾 **Salvamento:** Estado é salvo no localStorage do navegador
4. 🔁 **Próximo acesso:** Sistema lembra o estado (expandido/recolhido)

### Exemplo:
```javascript
// Se você expandir "Registros" e recarregar a página:
// → "Registros" continuará expandido (salvo no localStorage)

// Se você NÃO interagir com nenhum menu:
// → Todos ficam recolhidos (padrão)
```

---

## 🧹 Resetar Menus para Padrão

### Opção 1: Via Console do Navegador
1. Pressione `F12` para abrir DevTools
2. Vá na aba **Console**
3. Digite e execute:
```javascript
resetMenus()
```
4. A página recarregará com todos os menus recolhidos

### Opção 2: Limpar localStorage Manualmente
1. Pressione `F12` → Aba **Application** (Chrome) ou **Storage** (Firefox)
2. Localize **Local Storage** → `http://seu-dominio.local`
3. Apague as chaves que começam com `menu-group-`
4. Recarregue a página

### Opção 3: Navegação Anônima
- Use o modo anônimo/privado do navegador
- Todos os menus estarão no estado padrão (recolhidos)

---

## 🎨 Customizações

### Mudar o comportamento padrão

Para alterar qual grupo inicia expandido, edite `views/layouts/app.php`:

```javascript
// Exemplo: Sempre expandir o grupo "Gestão" (índice 3)
if (savedState === 'expanded' || index === 3) {
    header.classList.remove('collapsed');
    header.nextElementSibling.classList.remove('collapsed');
}
```

### Desabilitar persistência

Para desabilitar o salvamento no localStorage:

```javascript
// Remover estas linhas:
localStorage.setItem('menu-group-' + index, ...);
localStorage.getItem('menu-group-' + index);
```

---

## 🔧 Estrutura Técnica

### HTML
```html
<!-- Header do grupo (clicável) -->
<div class="menu-group-header collapsed" onclick="toggleMenuGroup(this)">
    <span>Nome do Grupo</span>
    <i class="bi bi-chevron-down toggle-icon"></i>
</div>

<!-- Itens do grupo (recolhidos) -->
<div class="menu-group-items collapsed">
    <a href="/rota.php" class="sidebar-item">Item</a>
</div>
```

### CSS
```css
.menu-group-header.collapsed i.toggle-icon {
    transform: rotate(-90deg); /* Seta para direita */
}

.menu-group-items.collapsed {
    max-height: 0;
    opacity: 0;
    overflow: hidden;
}
```

### JavaScript
```javascript
function toggleMenuGroup(header) {
    const items = header.nextElementSibling;
    header.classList.toggle('collapsed');
    items.classList.toggle('collapsed');
}
```

---

## 🐛 Troubleshooting

### Problema: Menus continuam expandidos mesmo após atualizar o código

**Causa:** localStorage ainda tem valores antigos salvos

**Solução:**
```javascript
// No console do navegador:
resetMenus()
```

### Problema: Menus não expandem ao clicar

**Causa:** JavaScript não está carregado ou há erro no console

**Solução:**
1. Verifique o console do navegador (F12)
2. Certifique-se de que `app.js` está carregando
3. Limpe o cache do navegador (Ctrl+F5)

---

## 📊 localStorage Keys

O sistema usa as seguintes chaves:

```
menu-group-0 → Registros
menu-group-1 → Operacional
menu-group-2 → Financeiro
menu-group-3 → Gestão
```

**Valores possíveis:**
- `"expanded"` - Menu expandido
- `"collapsed"` - Menu recolhido
- `null` - Sem valor (usa padrão: recolhido)

---

## 🎓 Boas Práticas

### Para Usuários:
✅ Expanda apenas os grupos que você usa com frequência
✅ Use `resetMenus()` se a sidebar ficar "bagunçada"
✅ Menus recolhidos economizam espaço visual

### Para Desenvolvedores:
✅ Mantenha o padrão sempre recolhido
✅ Use classes consistentes (`collapsed`)
✅ Sempre teste em navegação anônima
✅ Documente mudanças no comportamento

---

## 📝 Changelog

**v1.1.0 - 13/10/2025**
- ✅ Padrão alterado para **todos recolhidos**
- ✅ Adicionada função `resetMenus()` para desenvolvimento
- ✅ Persistência no localStorage mantida
- ✅ Documentação completa criada

**v1.0.0 - Inicial**
- Criação do menu expansível
- Sistema de persistência com localStorage

---

**Desenvolvido com ❤️ pela equipe Systhema**
**Licença:** Proprietário

