# Estrutura MVC do Systhema

## 📁 Organização do Projeto

O projeto foi reorganizado seguindo o padrão MVC (Model-View-Controller) para melhor manutenibilidade e organização.

### 🏗️ Estrutura de Diretórios

```
Systhema/
├── 📁 config/                 # Configurações do sistema
│   ├── app.php               # Configurações gerais
│   ├── database.php          # Configurações de banco
│   ├── mail.php              # Configurações de email
│   └── payment.php           # Configurações de pagamento
│
├── 📁 database/              # Scripts de banco de dados
│   ├── master_schema.sql     # Schema do banco master
│   ├── tenant_schema.sql     # Schema dos tenants
│   └── migration_*.sql       # Scripts de migração
│
├── 📁 docs/                  # Documentação do projeto
│   ├── *.md                  # Arquivos de documentação
│   ├── *.txt                 # Arquivos de configuração
│   ├── *.bat                 # Scripts Windows
│   ├── *.ps1                 # Scripts PowerShell
│   ├── *.html                # Páginas de demonstração
│   └── *.conf                # Configurações Apache
│
├── 📁 public/                # Arquivos públicos e rotas
│   ├── 📁 assets/            # CSS, JS, imagens, fonts
│   └── 📁 routes/            # Arquivos de acesso direto (116 arquivos)
│
├── 📁 routes/                # Definições de rotas
│   ├── web.php               # Rotas web
│   └── api.php               # Rotas API
│
├── 📁 src/                   # Código fonte (MVC)
│   ├── 📁 Controllers/       # Controllers (23 arquivos)
│   ├── 📁 Core/              # Classes core do sistema
│   ├── 📁 Helpers/           # Funções auxiliares
│   ├── 📁 Middleware/        # Middlewares de autenticação
│   ├── 📁 Models/            # Models (vazio - usar Controllers)
│   └── 📁 Services/          # Serviços (NFe, PDF, Excel, etc.)
│
├── 📁 storage/               # Armazenamento
│   ├── 📁 cache/             # Cache do sistema
│   ├── 📁 logs/              # Logs de aplicação
│   ├── 📁 sessions/          # Sessões PHP
│   └── 📁 uploads/           # Uploads de usuários
│
├── 📁 vendor/                # Dependências do Composer
│
├── 📁 views/                 # Templates (Views)
│   ├── 📁 auth/              # Views de autenticação
│   ├── 📁 layouts/           # Layouts base
│   ├── 📁 dashboard/         # Views do dashboard
│   ├── 📁 usuarios/          # Views de usuários
│   ├── 📁 pessoas/           # Views de pessoas
│   ├── 📁 vendas/            # Views de vendas
│   └── ...                   # Views de outros módulos
│
├── index.php                 # Ponto de entrada principal
├── composer.json             # Dependências PHP
├── composer.lock             # Lock das dependências
├── LICENSE                   # Licença do projeto
└── .htaccess                 # Configurações Apache
```

## 🎯 Padrão MVC Implementado

### 📋 Controllers (`src/Controllers/`)
- **23 Controllers** implementados
- Cada módulo tem seu próprio Controller
- Métodos: `index()`, `create()`, `store()`, `edit()`, `update()`, `delete()`
- Herdam de `BaseController` para funcionalidades comuns

### 🖼️ Views (`views/`)
- Templates organizados por módulo
- Layout base em `views/layouts/app.php`
- Views específicas: `index.php`, `create.php`, `edit.php`, `form.php`
- Sistema de variáveis para passar dados do Controller

### 🛣️ Rotas (`routes/` + `public/routes/`)
- **Rotas definidas**: `web.php` e `api.php`
- **Arquivos de acesso direto**: 116 arquivos em `public/routes/`
- Sistema de roteamento com middleware de autenticação
- URLs amigáveis com `.htaccess`

## 🔧 Arquivos de Acesso Direto

Os arquivos em `public/routes/` são pontos de entrada para URLs amigáveis:

```php
<?php
$_GET['_route'] = '/usuarios/criar';
require_once '../../index.php';
```

### 📊 Módulos Disponíveis:
- **Usuários** (usuarios-*.php)
- **Pessoas** (pessoas-*.php)
- **Empresas** (empresas-*.php)
- **Vendas** (vendas-*.php)
- **Produtos** (produtos-*.php)
- **Contas** (contas-*.php)
- **Dashboard** (dashboard.php)
- **E mais 20+ módulos**

## 📚 Documentação

Toda documentação está organizada em `docs/`:
- **README.md** - Documentação principal
- **SETUP_RAPIDO.md** - Setup rápido
- **PARAMETROS.md** - Configuração de parâmetros
- **FUNCOES_GLOBAIS.md** - Funções JavaScript globais
- **E mais 15+ arquivos de documentação**

## 🚀 Vantagens da Nova Estrutura

✅ **Organização**: Código separado por responsabilidade
✅ **Manutenibilidade**: Fácil localização de arquivos
✅ **Escalabilidade**: Estrutura preparada para crescimento
✅ **Padrão MVC**: Seguindo boas práticas
✅ **Documentação**: Tudo organizado em `docs/`
✅ **Segurança**: Arquivos sensíveis protegidos
✅ **Performance**: Estrutura otimizada

## 🔄 Migração Realizada

- ✅ **116 arquivos PHP** movidos de `raiz/` para `public/routes/`
- ✅ **25 arquivos de documentação** movidos para `docs/`
- ✅ **Caminhos corrigidos** automaticamente
- ✅ **Estrutura MVC** implementada
- ✅ **Funcionalidade preservada** - tudo continua funcionando

**O projeto agora segue uma estrutura MVC profissional e organizada!** 🎉
