# 🔑 Configuração da API do cPanel - Guia Passo a Passo

## 📋 Passo 1: Obter API Token

### **Acessar o cPanel:**
1. Acesse: `https://Systhema.com.br:2083`
2. Faça login com suas credenciais

### **Gerar API Token:**
1. No cPanel, procure por **"Manage API Tokens"** ou **"Gerenciar Tokens de API"**
   - Geralmente em: `Segurança` → `Manage API Tokens`

2. Clique em **"Create"** ou **"Criar Token"**

3. Preencha:
   - **Name:** `Systhema_subdomain_automation`
   - **Expiration:** `Unlimited` ou data futura

4. Clique em **"Create"**

5. **COPIE O TOKEN IMEDIATAMENTE!** Ele só é mostrado uma vez
   ```
   Exemplo: lkjsdf09832lkjsdflkj2309lkjsdflkj23lkjsdf
   ```

---

## 📝 Passo 2: Configurar o `.env`

Edite o arquivo `.env` na raiz do projeto e adicione:

```env
# ========================================
# CONFIGURAÇÃO DO CPANEL
# ========================================

# Tipo de painel
HOSTING_PANEL=cpanel

# Domínio base
BASE_DOMAIN=Systhema.com.br

# URL da API do cPanel (porta padrão: 2083 para HTTPS)
CPANEL_API_URL=https://Systhema.com.br:2083

# Usuário do cPanel
CPANEL_API_USER=seu_usuario_cpanel

# Token da API (copiado no passo anterior)
CPANEL_API_TOKEN=lkjsdf09832lkjsdflkj2309lkjsdflkj23lkjsdf

# Diretório raiz (geralmente public_html)
DOCUMENT_ROOT=/public_html
```

### **Como descobrir o usuário do cPanel:**
- Geralmente é o mesmo que você usa para fazer login no cPanel
- Pode verificar em: `cPanel → Informações da Conta`

---

## 🧪 Passo 3: Testar a Configuração

Execute o script de teste:

```bash
cd /caminho/para/Systhema
php testar_cpanel_api.php
```

Deve retornar:
```
✅ Conectado ao cPanel com sucesso!
✅ Teste de criação de subdomínio: SUCESSO
```

---

## 🔒 Segurança

### **Permissões do Token:**
O token deve ter permissões para:
- ✅ `SubDomain::add_subdomain` (criar subdomínios)
- ✅ `SubDomain::list_domains` (listar subdomínios)

### **Restrições de IP (Opcional):**
Para maior segurança, você pode restringir o token a IPs específicos no cPanel.

---

## 🚀 Como Funciona

Quando alguém se registrar no sistema:

1. **Usuário preenche formulário:**
   - Empresa: "PrintJet Digital"
   - Subdomínio: `printjetdigital`

2. **Sistema cria tenant:**
   - Banco de dados: `Systhema_tenant_printjetdigital`
   - Registro no banco master

3. **API do cPanel cria subdomínio:**
   - Subdomínio: `printjetdigital.Systhema.com.br`
   - Diretório: `/public_html/printjetdigital`
   - Configuração automática de DNS

4. **Redirecionamento automático:**
   - Usuário é redirecionado para: `https://printjetdigital.Systhema.com.br/login`

---

## ❌ Troubleshooting

### **Erro: "Unauthorized" ou HTTP 401**
- ❌ Token inválido ou expirado
- ✅ Gere um novo token no cPanel

### **Erro: "Connection timeout"**
- ❌ URL da API incorreta
- ✅ Verifique se a porta é 2083 (HTTPS) ou 2082 (HTTP)
- ✅ Verifique firewall do servidor

### **Erro: "Permission denied"**
- ❌ Token sem permissões adequadas
- ✅ Recrie o token com permissões de "SubDomain"

### **Subdomínio criado mas não funciona:**
- ❌ DNS não propagado (aguarde alguns minutos)
- ✅ Verifique se o diretório foi criado em `/public_html`
- ✅ Verifique logs do Apache: `tail -f /var/log/apache2/error.log`

---

## 📚 Referências

- [cPanel API Documentation](https://api.docs.cpanel.net/)
- [SubDomain API Functions](https://api.docs.cpanel.net/openapi/cpanel/operation/add_subdomain/)

---

## ✅ Checklist

- [ ] Token da API criado no cPanel
- [ ] Token copiado e salvo
- [ ] `.env` configurado com as credenciais
- [ ] Script de teste executado com sucesso
- [ ] Testar criação de um tenant
- [ ] Verificar se o subdomínio foi criado no cPanel
- [ ] Acessar o subdomínio criado

