# ✅ Correção: Erro "ID da venda inválido" ao Emitir NFS-e

## 🐛 **Problema:**

Ao tentar emitir NFS-e, ocorria erro:
```
POST https://Systhema.com.br/Systhema/vendas/emitir-nfse 400 (Bad Request)
Erro: ID da venda inválido
```

## 🔍 **Causa:**

O JavaScript envia os dados como **JSON** (`Content-Type: application/json`), mas o controller PHP tentava ler de `$_POST`, que não é preenchido automaticamente quando o corpo é JSON.

Quando você envia JSON, o PHP não popula `$_POST` automaticamente. É necessário ler do corpo da requisição (`php://input`).

---

## ✅ **Correção Implementada:**

### **Arquivo modificado:**
- `Systhema/src/Controllers/VendasController.php` - Método `emitirNfse()`

### **Mudanças:**

1. **Detecta requisição JSON:**
   ```php
   if ($this->request->isJson()) {
       $input = file_get_contents('php://input');
       $requestData = json_decode($input, true) ?? [];
   } else {
       $requestData = $_POST;
   }
   ```

2. **Lê dados do array correto:**
   ```php
   $vendaId = (int) ($requestData['venda_id'] ?? $this->request->post('venda_id') ?? 0);
   ```

3. **Atualiza todos os campos para ler do JSON:**
   - `codigo_servico`
   - `codigo_tributacao`
   - `descricao_servico`
   - `aliquota_iss`
   - `natureza_operacao`
   - `regime_tributacao`
   - `optante_simples`
   - `iss_retido`

---

## ✅ **Resultado:**

Agora o sistema:
- ✅ Lê corretamente requisições JSON
- ✅ Mantém compatibilidade com POST normal (form-urlencoded)
- ✅ Recebe `venda_id` corretamente
- ✅ Processa todos os campos da NFS-e

---

## 🧪 **Como Testar:**

1. Vá em **Vendas** → Escolha uma venda
2. Clique em **"Emitir NFS-e"**
3. Preencha os dados
4. Clique em **"Emitir NFS-e"**
5. Deve funcionar sem erro! ✅

---

## 📝 **Nota sobre o erro de extensão:**

O erro no console sobre `content_script.js` é de uma **extensão do navegador** (provavelmente um autocomplete de senha ou similar). Esse erro não afeta o funcionamento do sistema e pode ser ignorado.
