# ✅ Configuração: Portal Nacional usando APENAS Certificado Digital

## 🎯 **SIM! Pode usar APENAS certificado digital!**

Você não precisa configurar OAuth2. Basta ter o **certificado digital** configurado na empresa e ativar o Portal Nacional.

---

## 📋 **Como Configurar:**

### **1. Certificado Digital** (já deve estar configurado)
- ✅ Vá em **Empresas** → **Editar Empresa**
- ✅ Aba **"Dados Principais"**
- ✅ Certificado digital (.pfx) carregado
- ✅ Senha do certificado configurada

### **2. Ativar Portal Nacional**
- ✅ Vá em **Empresas** → **Editar Empresa**
- ✅ Aba **"Integrações"**
- ✅ Seção **"Portal Nacional de NFS-e"**
- ✅ Marque: **"Ativar integração com Portal Nacional de NFS-e"**
- ✅ **Deixe os campos OAuth2 VAZIOS** (Client ID e Secret)
- ✅ Marque homologação (para testar primeiro)
- ✅ Salve

### **3. Pronto!**
Agora você pode emitir NFS-e e o sistema usará automaticamente o certificado digital para autenticação!

---

## 🔧 **Como Funciona:**

### **Com Apenas Certificado:**
```
1. Sistema detecta que OAuth2 está vazio
2. Usa certificado digital configurado na empresa
3. Faz requisição HTTPS com mutual TLS (certificado no handshake)
4. Portal Nacional identifica empresa pelo certificado
5. Emite NFS-e autorizada
```

### **Com OAuth2 (Opcional):**
```
1. Sistema detecta que OAuth2 está preenchido
2. Autentica via OAuth2 (obtém token)
3. Faz requisição HTTPS com token Bearer
4. Emite NFS-e autorizada
```

---

## ✅ **Vantagens de Usar Apenas Certificado:**

- ✅ **Mais Simples**: Não precisa cadastrar OAuth2
- ✅ **Mais Seguro**: Autenticação direta via certificado
- ✅ **Menos Configuração**: Usa certificado que já está no sistema
- ✅ **Menos Pontos de Falha**: Não depende de tokens que expiram

---

## ⚠️ **Importante:**

O certificado digital deve estar:
- ✅ Válido (não expirado)
- ✅ Do tipo A1 ou A3 (e-CNPJ)
- ✅ Com CNPJ da empresa
- ✅ Configurado corretamente no sistema

---

## 🎉 **Pronto!**

Agora você pode emitir NFS-e usando apenas certificado digital, sem precisar configurar OAuth2!
