# 📝 Changelog - Endereços Completos em Empresas

**Data:** 13 de Outubro de 2025
**Autor:** Romildo Conegundes
**Versão:** 1.1.0

---

## 🎯 O que mudou

### ✅ Novos Campos Adicionados

Agora o cadastro de empresas possui endereço completo com:

- **Número** - Campo separado para número do logradouro
- **Complemento** - Sala, andar, bloco, etc.
- **Bairro** - Auto-preenchido pela API ViaCEP

### 📊 Banco de Dados

**Tabela afetada:** `companies`

**Novas colunas:**
```sql
numero VARCHAR(20) NULL
complemento VARCHAR(100) NULL
bairro VARCHAR(100) NULL
```

### 🎨 Interface

**Formulário de Empresas (`/empresas-criar.php` e `/empresas-editar.php`)**

Layout reorganizado:
- CEP (3 colunas) - com ícone de busca automática
- Logradouro (7 colunas)
- Número (2 colunas)
- Complemento (4 colunas)
- Bairro (4 colunas)
- UF (2 colunas)
- Cidade (6 colunas)

**Listagem de Empresas (`/empresas.php`)**

Nova coluna "Endereço" que exibe:
- Logradouro, Número, Bairro (quando preenchidos)
- Formato: "Rua ABC, 123, Centro"

---

## 🔌 Integrações

### API ViaCEP - Melhorada
Ao digitar um CEP válido, agora preenche automaticamente:
- ✅ Logradouro
- ✅ **Bairro** (NOVO!)
- ✅ Cidade
- ✅ UF

### API ReceitaWS (CNPJ) - Melhorada
Ao buscar por CNPJ, preenche:
- Razão Social
- Nome Fantasia
- Email
- Telefone
- CEP
- Logradouro
- **Número** (quando disponível)
- **Complemento** (quando disponível)
- **Bairro** (quando disponível)
- Cidade
- UF

---

## 📁 Arquivos Modificados

### Backend
- ✏️ `database/tenant_schema.sql` - Schema atualizado
- ✏️ `src/Controllers/EmpresasController.php` - CRUD atualizado
- 🆕 `database/migration_add_address_fields.sql` - Migração

### Frontend
- ✏️ `views/empresas/form.php` - Formulário com novos campos
- ✏️ `views/empresas/index.php` - Listagem com endereço completo

### Documentação
- 🆕 `MIGRAR_ENDERECO.md` - Instruções de migração
- 🆕 `CHANGELOG_EMPRESAS_ENDERECO.md` - Este arquivo

---

## 🚀 Como Aplicar

### 1. Atualizar Banco de Dados Existente

Para cada tenant já criado, execute:

```sql
ALTER TABLE companies
ADD COLUMN numero VARCHAR(20) NULL AFTER address,
ADD COLUMN complemento VARCHAR(100) NULL AFTER numero,
ADD COLUMN bairro VARCHAR(100) NULL AFTER complemento;
```

Ou use o arquivo de migração:
```bash
mysql -u root SEU_BANCO < database/migration_add_address_fields.sql
```

### 2. Novos Tenants

✅ Já estão automaticamente atualizados!
O schema `tenant_schema.sql` já contém as novas colunas.

---

## 🎓 Exemplo de Uso

### Cadastrando uma empresa com CEP:

1. Digite o CEP: `01310-100`
2. Sistema preenche automaticamente:
   - Logradouro: "Avenida Paulista"
   - Bairro: "Bela Vista"
   - Cidade: "São Paulo"
   - UF: "SP"
3. Complete manualmente:
   - Número: "1578"
   - Complemento: "Andar 12, Sala 125"

### Resultado salvo:
```
Av. Paulista, 1578, Bela Vista
São Paulo/SP - 01310-100
```

---

## 🐛 Correções de Bugs

- ✅ Busca de CEP agora valida 8 dígitos antes de chamar a API
- ✅ Campos vazios não aparecem na listagem (evita vírgulas extras)
- ✅ Máscaras aplicadas automaticamente em todos os campos

---

## 📞 Suporte

**Desenvolvedor:** Romildo Conegundes
**Email:** romildo@Systhema.com.br
**Empresa:** Systhema
**Licença:** Proprietário

---

## 🔄 Próximas Atualizações

- [ ] Validação de CNPJ/CPF no backend
- [ ] Geolocalização (lat/lng) por endereço
- [ ] Integração com Google Maps
- [ ] Múltiplos endereços por empresa

