# 📋 Chamado Técnico - Suporte Eveo

## 🔴 Problema 1: Erro "Call to undefined function App\Core\shell_exec()"

### Descrição
O sistema PHP está retornando erro fatal ao tentar chamar a função `shell_exec()` dentro do namespace `App\Core`. O PHP está procurando a função no namespace errado, quando deveria usar a função global.

### Detalhes Técnicos
- **Namespace:** `App\Core`
- **Função esperada:** `shell_exec()` (função global do PHP)
- **Erro:** PHP procura por `App\Core\shell_exec()` ao invés de `\shell_exec()`

### Possíveis Causas
1. Função `shell_exec()` desabilitada no `php.ini` via `disable_functions`
2. OPcache servindo código antigo/cached
3. Problema de autoload ou namespace do PHP

### Solicitação ao Suporte
Por favor, verificar e informar:

1. **Verificar se `shell_exec` está desabilitada:**
   ```bash
   php -i | grep disable_functions
   ```

2. **Versão do PHP em uso:**
   ```bash
   php -v
   ```

3. **Limpar OPcache e reiniciar PHP-FPM:**
   ```bash
   # Limpar cache do OPcache
   systemctl restart php-fpm
   # OU se for cPanel:
   systemctl restart php82-php-fpm
   ```

4. **Se `shell_exec` estiver desabilitada:**
   - Remover de `disable_functions` no `php.ini`
   - OU confirmar que está desabilitada e garantimos que o código não a utiliza

---

## 🔴 Problema 2: Erro OpenSSL "error:0308010C:digital envelope routines::unsupported"

### Descrição
Ao tentar carregar certificados digitais A1 (.pfx), o sistema retorna erro:
```
error:0308010C:digital envelope routines::unsupported
```

### Detalhes Técnicos
- **OpenSSL Version:** 3.x (verificar com `openssl version`)
- **Problema:** OpenSSL 3.x desabilitou algoritmos legados por padrão
- **Certificados afetados:** Certificados que usam algoritmos legados (MD5, SHA-1, ou algoritmos de criptografia antigos)

### Solicitação ao Suporte
Precisamos configurar o OpenSSL para habilitar o provedor "legacy" que permite o uso de algoritmos legados.

#### Passo 1: Criar arquivo de configuração OpenSSL

Criar arquivo: `/etc/ssl/openssl-legacy.cnf`

Conteúdo:
```ini
openssl_conf = openssl_init

[openssl_init]
providers = provider_sect

[provider_sect]
default = default_sect
legacy = legacy_sect

[default_sect]
activate = 1

[legacy_sect]
activate = 1
```

Permissões:
```bash
chmod 644 /etc/ssl/openssl-legacy.cnf
```

#### Passo 2: Configurar variável de ambiente OPENSSL_CONF no PHP-FPM

**Opção A: Configurar no pool do PHP-FPM**

Editar arquivo do pool PHP-FPM:
- cPanel: `/opt/cpanel/ea-php82/root/etc/php-fpm.d/www.conf` (ajustar versão)
- Padrão: `/etc/php-fpm.d/www.conf`

Adicionar na seção `[www]`:
```ini
[www]
env[OPENSSL_CONF] = /etc/ssl/openssl-legacy.cnf
```

**Opção B: Configurar globalmente**

Adicionar no `/etc/php-fpm.conf` ou arquivo principal:
```ini
env[OPENSSL_CONF] = /etc/ssl/openssl-legacy.cnf
```

#### Passo 3: Reiniciar PHP-FPM

```bash
# Verificar versão do PHP em uso
php -v

# Reiniciar PHP-FPM correspondente
systemctl restart php-fpm
# OU
systemctl restart php82-php-fpm
# OU via cPanel
/usr/local/cpanel/scripts/restartsrv_php-fpm
```

#### Passo 4: Verificar se funcionou

```bash
# Testar se a variável está configurada
php -r "echo 'OpenSSL: ' . OPENSSL_VERSION_TEXT . PHP_EOL; echo 'OPENSSL_CONF: ' . getenv('OPENSSL_CONF') . PHP_EOL;"

# Resultado esperado:
# OpenSSL: OpenSSL 3.0.x ...
# OPENSSL_CONF: /etc/ssl/openssl-legacy.cnf
```

---

## 📊 Informações do Ambiente

**Sistema:** cPanel/WHM (servidor dedicado Eveo)
**PHP Version:** [INFORMAR VERSÃO]
**OpenSSL Version:** [VERIFICAR COM: `openssl version`]

**Arquivos afetados:**
- Emissão de NF-e (Nota Fiscal Eletrônica)
- Carregamento de certificados digitais A1 (.pfx)

---

## ✅ Resultado Esperado

Após as configurações:
1. ✅ Função `shell_exec()` funcionando corretamente (ou código adaptado sem dependência)
2. ✅ OpenSSL 3.x habilitado para suportar algoritmos legados
3. ✅ Certificados digitais A1 carregando sem erro `error:0308010C`
4. ✅ Emissão de NF-e funcionando normalmente

---

## 📝 Notas Adicionais

- Aplicação PHP desenvolvida em MVC com namespace `App\Core`
- Usa certificados digitais A1 para assinatura de documentos fiscais
- Necessário suporte a algoritmos legados para compatibilidade com certificados antigos

---

## 🔗 Referências Técnicas

- OpenSSL 3.x Migration Guide: https://www.openssl.org/docs/man3.0/man7/migration_guide.html
- PHP disable_functions: https://www.php.net/manual/en/ini.core.php#ini.disable-functions
- OpenSSL Legacy Provider: https://www.openssl.org/docs/man3.0/man7/provider-legacy.html
