# 🔐 Autenticação com Certificado Digital no Portal Nacional de NFS-e

## ✅ **SIM! Você pode usar APENAS certificado digital!**

O Portal Nacional de NFS-e aceita autenticação via **certificado digital** diretamente nas requisições HTTPS (mutual TLS), sem precisar de OAuth2.

---

## 🎯 **Duas Opções de Autenticação:**

### **Opção 1: Apenas Certificado Digital** ⭐ **RECOMENDADO - MAIS SIMPLES**

✅ **Vantagens:**
- Não precisa cadastrar OAuth2
- Usa o certificado que já está configurado na empresa
- Mais simples de configurar
- Mais seguro (autenticação direta)

**O que precisa:**
- ✅ Certificado digital A1 ou A3 (e-CNPJ) configurado na empresa
- ✅ Senha do certificado configurada
- ✅ Portal Nacional ativado

**Como usar:**
1. Vá em **Empresas** → **Editar**
2. Aba **"Integrações"**
3. Ative **"Portal Nacional de NFS-e"**
4. **Deixe os campos OAuth2 vazios**
5. O sistema usará automaticamente o certificado digital!

---

### **Opção 2: OAuth2 (Opcional)**

Se preferir usar OAuth2:
- Preencha Client ID e Client Secret
- O sistema usará OAuth2 ao invés do certificado

---

## 🔧 **Como Funciona Tecnicamente:**

### **Com Certificado Digital:**
```php
// Requisição HTTPS com mutual TLS
curl_setopt_array($ch, [
    CURLOPT_SSLCERT => '/caminho/certificado.pfx',
    CURLOPT_SSLCERTPASSWD => 'senha',
    CURLOPT_SSLCERTTYPE => 'P12',
    // O certificado é enviado na conexão HTTPS
]);
```

O certificado digital é usado para:
- Autenticar a empresa (mutual TLS)
- Identificar o CNPJ automaticamente
- Assinar as requisições

---

## ✅ **Status da Implementação:**

### **Já Implementado:**
- ✅ Suporte a certificado digital no cliente HTTP
- ✅ Detecção automática (OAuth2 OU certificado)
- ✅ Interface permite deixar OAuth2 vazio
- ✅ Usa certificado se OAuth2 não estiver configurado

---

## 📋 **Checklist:**

### **Para usar apenas certificado digital:**

1. ✅ Certificado digital configurado na empresa (aba "Dados Principais")
   - Certificado .pfx carregado
   - Senha do certificado configurada

2. ✅ Portal Nacional ativado (aba "Integrações")
   - Marcar "Ativar integração"
   - Deixar OAuth2 vazio
   - Escolher homologação ou produção

3. ✅ Pronto para emitir!

---

## 🎉 **Resultado:**

Agora você pode usar **APENAS certificado digital** para emitir NFS-e via Portal Nacional, sem precisar configurar OAuth2!

**Muito mais simples! 🚀**
