<?php
/**
 * Script para verificar onde os status foram criados
 */

$dbName = $argv[1] ?? 'Systhema';

require_once __DIR__ . '/../vendor/autoload.php';

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->load();

$host = $_ENV['DB_MASTER_HOST'] ?? 'localhost';
$port = $_ENV['DB_MASTER_PORT'] ?? 3306;
$user = $_ENV['DB_MASTER_USER'] ?? 'root';
$pass = $_ENV['DB_MASTER_PASS'] ?? '';

try {
    $pdo = new PDO(
        "mysql:host={$host};port={$port};dbname={$dbName};charset=utf8mb4",
        $user,
        $pass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    echo "=== VERIFICAÇÃO DE STATUS ===\n\n";
    echo "Banco de dados: {$dbName}\n";
    echo "Tabela: modulo_status\n\n";

    // Verificar se a tabela existe
    $stmt = $pdo->query("SHOW TABLES LIKE 'modulo_status'");
    $tabelaExiste = $stmt->fetch() !== false;

    if (!$tabelaExiste) {
        echo "❌ A tabela 'modulo_status' não existe neste banco!\n";
        exit(1);
    }

    echo "✅ Tabela 'modulo_status' existe\n\n";

    // Contar total de registros
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM modulo_status");
    $total = $stmt->fetch()['total'];
    echo "📊 Total de status cadastrados: {$total}\n\n";

    // Listar todas as empresas que têm status
    echo "🏢 Empresas com status cadastrados:\n";
    $stmt = $pdo->query("
        SELECT DISTINCT
            ms.company_id,
            c.name as empresa_nome,
            ms.modulo,
            COUNT(*) as qtd_status
        FROM modulo_status ms
        LEFT JOIN companies c ON c.id = ms.company_id
        GROUP BY ms.company_id, ms.modulo
        ORDER BY ms.company_id, ms.modulo
    ");
    $empresas = $stmt->fetchAll();

    if (empty($empresas)) {
        echo "   ⚠️  Nenhuma empresa com status encontrada\n";
    } else {
        foreach ($empresas as $emp) {
            echo "   - Empresa ID: {$emp['company_id']} - {$emp['empresa_nome']}\n";
            echo "     Módulo: {$emp['modulo']} | {$emp['qtd_status']} status)\n";
        }
    }

    // Listar todos os status detalhadamente
    echo "\n📋 Detalhes dos Status:\n";
    echo str_repeat("=", 100) . "\n";

    $stmt = $pdo->query("
        SELECT
            ms.id,
            ms.company_id,
            c.name as empresa_nome,
            ms.modulo,
            ms.codigo,
            ms.nome,
            ms.descricao,
            ms.gera_financeiro,
            ms.movimenta_estoque,
            ms.cor,
            ms.icone,
            ms.ordem,
            ms.is_default,
            ms.is_final,
            ms.ativo,
            ms.created_at
        FROM modulo_status ms
        LEFT JOIN companies c ON c.id = ms.company_id
        ORDER BY ms.company_id, ms.modulo, ms.ordem
    ");
    $status = $stmt->fetchAll();

    if (empty($status)) {
        echo "   ⚠️  Nenhum status encontrado\n";
    } else {
        foreach ($status as $s) {
            echo "ID: {$s['id']}\n";
            echo "  Empresa: {$s['empresa_nome']} (ID: {$s['company_id']})\n";
            echo "  Módulo: {$s['modulo']}\n";
            echo "  Código: {$s['codigo']}\n";
            echo "  Nome: {$s['nome']}\n";
            echo "  Descrição: {$s['descricao']}\n";
            echo "  Gera Financeiro: " . ($s['gera_financeiro'] ? 'SIM' : 'NÃO') . "\n";
            echo "  Movimenta Estoque: " . ($s['movimenta_estoque'] ? 'SIM' : 'NÃO') . "\n";
            echo "  Cor: {$s['cor']}\n";
            echo "  Ícone: {$s['icone']}\n";
            echo "  Ordem: {$s['ordem']}\n";
            echo "  Status Padrão: " . ($s['is_default'] ? 'SIM' : 'NÃO') . "\n";
            echo "  Status Final: " . ($s['is_final'] ? 'SIM' : 'NÃO') . "\n";
            echo "  Ativo: " . ($s['ativo'] ? 'SIM' : 'NÃO') . "\n";
            echo "  Criado em: {$s['created_at']}\n";
            echo str_repeat("-", 100) . "\n";
        }
    }

    // Consulta SQL para usar diretamente
    echo "\n📝 Consulta SQL para verificar os status:\n";
    echo str_repeat("=", 100) . "\n";
    echo "SELECT * FROM modulo_status WHERE modulo = 'vendas' ORDER BY ordem;\n\n";

} catch (Exception $e) {
    echo "❌ ERRO: " . $e->getMessage() . "\n";
    exit(1);
}

