-- ============================================
-- Migration: Mover campos de licenças de produtos para pessoas
-- Data: 2025-01-XX
-- Descrição: Move os campos de licenças (Anvisa, Conselho de Farmácia, etc)
--            da tabela produtos para a tabela pessoas
-- ============================================

-- Adicionar colunas na tabela pessoas (se não existirem)
SET @dbname = DATABASE();

-- Verificar e adicionar data_anvisa
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'pessoas' AND COLUMN_NAME = 'data_anvisa');
SET @sql = IF(@colExists = 0,
    'ALTER TABLE pessoas ADD COLUMN data_anvisa DATE NULL COMMENT "Data de validade Anvisa" AFTER area_comercial_id',
    'SELECT "Coluna data_anvisa já existe em pessoas" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar e adicionar data_conselho_farmacia
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'pessoas' AND COLUMN_NAME = 'data_conselho_farmacia');
SET @sql = IF(@colExists = 0,
    'ALTER TABLE pessoas ADD COLUMN data_conselho_farmacia DATE NULL COMMENT "Data de validade Conselho de Farmácia" AFTER data_anvisa',
    'SELECT "Coluna data_conselho_farmacia já existe em pessoas" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar e adicionar data_vigilancia_sanitaria
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'pessoas' AND COLUMN_NAME = 'data_vigilancia_sanitaria');
SET @sql = IF(@colExists = 0,
    'ALTER TABLE pessoas ADD COLUMN data_vigilancia_sanitaria DATE NULL COMMENT "Data de validade Vigilância Sanitária" AFTER data_conselho_farmacia',
    'SELECT "Coluna data_vigilancia_sanitaria já existe em pessoas" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar e adicionar data_alvara_localizacao
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'pessoas' AND COLUMN_NAME = 'data_alvara_localizacao');
SET @sql = IF(@colExists = 0,
    'ALTER TABLE pessoas ADD COLUMN data_alvara_localizacao DATE NULL COMMENT "Data de validade Alvará de Localização" AFTER data_vigilancia_sanitaria',
    'SELECT "Coluna data_alvara_localizacao já existe em pessoas" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Remover colunas da tabela produtos (se existirem)
-- NOTA: Execute apenas se tiver certeza que não há dados importantes nessas colunas

-- Remover data_anvisa de produtos
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'produtos' AND COLUMN_NAME = 'data_anvisa');
SET @sql = IF(@colExists > 0,
    'ALTER TABLE produtos DROP COLUMN data_anvisa',
    'SELECT "Coluna data_anvisa não existe em produtos" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Remover data_conselho_farmacia de produtos
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'produtos' AND COLUMN_NAME = 'data_conselho_farmacia');
SET @sql = IF(@colExists > 0,
    'ALTER TABLE produtos DROP COLUMN data_conselho_farmacia',
    'SELECT "Coluna data_conselho_farmacia não existe em produtos" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Remover data_vigilancia_sanitaria de produtos
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'produtos' AND COLUMN_NAME = 'data_vigilancia_sanitaria');
SET @sql = IF(@colExists > 0,
    'ALTER TABLE produtos DROP COLUMN data_vigilancia_sanitaria',
    'SELECT "Coluna data_vigilancia_sanitaria não existe em produtos" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Remover data_alvara_localizacao de produtos
SET @colExists = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = @dbname AND TABLE_NAME = 'produtos' AND COLUMN_NAME = 'data_alvara_localizacao');
SET @sql = IF(@colExists > 0,
    'ALTER TABLE produtos DROP COLUMN data_alvara_localizacao',
    'SELECT "Coluna data_alvara_localizacao não existe em produtos" AS mensagem');
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SELECT 'Migration concluída: Campos de licenças movidos de produtos para pessoas' AS Mensagem;

