CREATE TABLE IF NOT EXISTS vendas_conferencia (
    id INT AUTO_INCREMENT PRIMARY KEY,
    venda_id INT NOT NULL,
    company_id INT NOT NULL,
    user_id INT NOT NULL,
    itens TEXT NOT NULL COMMENT 'JSON com os itens conferidos',
    created_at DATETIME NOT NULL,
    updated_at DATETIME DEFAULT NULL,
    INDEX idx_venda_id (venda_id),
    INDEX idx_company_id (company_id),
    FOREIGN KEY (venda_id) REFERENCES vendas(id) ON DELETE CASCADE,
    FOREIGN KEY (company_id) REFERENCES empresas(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

