-- Migration: Criar tabela para armazenar histórico de envios ao Sicacred
-- Data: 2025-12-15

CREATE TABLE IF NOT EXISTS sicacred_envios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    company_id INT NOT NULL,
    cod_fonte VARCHAR(7) NOT NULL COMMENT 'Código da Fonte (ex: CSL1704)',
    data_inicial DATE NOT NULL COMMENT 'Data inicial do período enviado',
    data_final DATE NOT NULL COMMENT 'Data final do período enviado',
    email_responsavel VARCHAR(255) NULL COMMENT 'Email do responsável informado',
    codigo_retorno INT NULL COMMENT 'Código de retorno do Sicacred (100: sucesso, 0: insucesso)',
    mensagem_retorno TEXT NULL COMMENT 'Mensagem de retorno do Sicacred',
    status ENUM('enviado', 'sucesso', 'erro') DEFAULT 'enviado' COMMENT 'Status do envio',
    total_clientes INT DEFAULT 0 COMMENT 'Total de clientes enviados',
    total_compras INT DEFAULT 0 COMMENT 'Total de compras enviadas',
    total_documentos INT DEFAULT 0 COMMENT 'Total de documentos enviados',
    producao TINYINT(1) DEFAULT 0 COMMENT '0=Homologação, 1=Produção',
    payload_json LONGTEXT NULL COMMENT 'Payload JSON enviado (para auditoria)',
    response_json LONGTEXT NULL COMMENT 'Resposta JSON recebida (para auditoria)',
    erro TEXT NULL COMMENT 'Mensagem de erro se houver',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    created_by INT NULL COMMENT 'ID do usuário que realizou o envio',

    INDEX idx_company_id (company_id),
    INDEX idx_cod_fonte (cod_fonte),
    INDEX idx_data_envio (created_at),
    INDEX idx_status (status),
    INDEX idx_codigo_retorno (codigo_retorno)
    -- Foreign key removida para evitar problemas de compatibilidade
    -- A integridade referencial será mantida pela aplicação
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Histórico de envios ao Sicacred';

