-- Migration: Criar tabela para armazenar posições dos locais de estoque
-- Data: 2025-01-XX

CREATE TABLE IF NOT EXISTS `local_estoque_posicoes` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `local_estoque_id` INT(11) UNSIGNED NOT NULL,
  `company_id` INT(11) UNSIGNED NOT NULL,
  `posicao` VARCHAR(255) NOT NULL COMMENT 'Descrição da posição (ex: Prateleira A-1, Corredor 2-B)',
  `ordem` INT(11) DEFAULT 0 COMMENT 'Ordem de exibição',
  `created_at` TIMESTAMP NULL DEFAULT NULL,
  `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_local_estoque_id` (`local_estoque_id`),
  KEY `idx_company_id` (`company_id`),
  CONSTRAINT `fk_local_estoque_posicoes_local`
    FOREIGN KEY (`local_estoque_id`)
    REFERENCES `locais_estoque` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_local_estoque_posicoes_company`
    FOREIGN KEY (`company_id`)
    REFERENCES `companies` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Posições físicas dentro de cada local de estoque';
