-- Migration: Criar tabela configuracoes_sistema
-- Descrição: Tabela para armazenar configurações globais do sistema, incluindo a skin ativa

CREATE TABLE IF NOT EXISTS `configuracoes_sistema` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `chave` VARCHAR(100) UNIQUE NOT NULL COMMENT 'Chave única da configuração',
    `valor` TEXT COMMENT 'Valor da configuração',
    `descricao` TEXT COMMENT 'Descrição do que a configuração faz',
    `tipo` VARCHAR(50) DEFAULT 'string' COMMENT 'Tipo: string, integer, boolean, json',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_chave` (`chave`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Configurações globais do sistema';

-- Inserir configuração inicial da skin
INSERT INTO `configuracoes_sistema` (`chave`, `valor`, `descricao`, `tipo`)
VALUES ('skin_ativa', 'aurion', 'Skin ativa do sistema (aurion, sanctus, etc)', 'string')
ON DUPLICATE KEY UPDATE `valor` = 'aurion';

