-- Migration: Criar tabela auxiliar agenda_tecnica_funcionarios_modulos
-- Descrição: Tabela para relacionar funcionários treinados com seus módulos específicos
-- Data: 2025-12-23
-- Estrutura: agenda_tecnica_id | funcionario_nome | modulo_nome

CREATE TABLE IF NOT EXISTS `agenda_tecnica_funcionarios_modulos` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `agenda_tecnica_id` INT UNSIGNED NOT NULL,
    `funcionario_nome` VARCHAR(255) NOT NULL,
    `modulo_nome` VARCHAR(255) NOT NULL,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_agenda_tecnica` (`agenda_tecnica_id`),
    INDEX `idx_funcionario` (`funcionario_nome`),
    UNIQUE KEY `uk_funcionario_modulo` (`agenda_tecnica_id`, `funcionario_nome`, `modulo_nome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

