-- Migration: Criar tabela auxiliar agenda_tecnica_funcionarios
-- Descrição: Tabela para relacionar múltiplos funcionários treinados com agendamentos
-- Data: 2025-12-23

CREATE TABLE IF NOT EXISTS `agenda_tecnica_funcionarios` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `agenda_tecnica_id` INT UNSIGNED NOT NULL,
    `funcionario_nome` VARCHAR(255) NOT NULL,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_agenda_tecnica` (`agenda_tecnica_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Adicionar foreign key se a tabela agenda_tecnica existir
-- Descomente a linha abaixo se a tabela agenda_tecnica já existir:
-- ALTER TABLE `agenda_tecnica_funcionarios`
-- ADD CONSTRAINT `fk_agenda_tecnica_funcionarios`
-- FOREIGN KEY (`agenda_tecnica_id`) REFERENCES `agenda_tecnica`(`id`) ON DELETE CASCADE;

