-- Migration: Criar tabela agenda_tecnica
-- Descrição: Tabela para gerenciar agendamentos técnicos e visitas
-- Data: 2025-12-23

CREATE TABLE IF NOT EXISTS `agenda_tecnica` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `company_id` INT UNSIGNED NOT NULL,
    `tecnico_id` INT UNSIGNED NULL,
    `cliente_id` INT UNSIGNED NULL,
    `titulo` VARCHAR(255) NOT NULL,
    `tipo_atendimento` VARCHAR(50) NULL,
    `descricao` TEXT NULL,
    `data_agendamento` DATE NOT NULL,
    `hora_inicio` TIME NOT NULL,
    `hora_fim` TIME NULL,
    `status` VARCHAR(50) DEFAULT 'agendado',
    `observacoes` TEXT NULL,
    `created_by` INT UNSIGNED NULL,
    `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_company` (`company_id`),
    INDEX `idx_tecnico` (`tecnico_id`),
    INDEX `idx_cliente` (`cliente_id`),
    INDEX `idx_data` (`data_agendamento`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Adicionar foreign keys (executar apenas se as tabelas referenciadas existirem)
-- Descomente as linhas abaixo se as tabelas existirem:

-- ALTER TABLE `agenda_tecnica`
-- ADD CONSTRAINT `fk_agenda_tecnica_company`
-- FOREIGN KEY (`company_id`) REFERENCES `companies`(`id`) ON DELETE CASCADE;

-- ALTER TABLE `agenda_tecnica`
-- ADD CONSTRAINT `fk_agenda_tecnica_tecnico`
-- FOREIGN KEY (`tecnico_id`) REFERENCES `users`(`id`) ON DELETE SET NULL;

-- ALTER TABLE `agenda_tecnica`
-- ADD CONSTRAINT `fk_agenda_tecnica_cliente`
-- FOREIGN KEY (`cliente_id`) REFERENCES `pessoas`(`id`) ON DELETE SET NULL;

