-- Migration: Adicionar colunas para integração Sicacred na tabela empresas
-- Data: 2025-01-XX

-- Adicionar colunas para configuração do Sicacred
ALTER TABLE empresas
ADD COLUMN IF NOT EXISTS sicacred_cod_fonte VARCHAR(7) NULL COMMENT 'Código da Fonte (ex: CSL1704)',
ADD COLUMN IF NOT EXISTS sicacred_cod_grp_emp VARCHAR(10) NULL COMMENT 'Código do Grupo Empresa',
ADD COLUMN IF NOT EXISTS sicacred_codigo_erp VARCHAR(10) NULL COMMENT 'Código do Sistema de Gestão/Envio',
ADD COLUMN IF NOT EXISTS sicacred_chave VARCHAR(255) NULL COMMENT 'Chave de Acesso fornecida pela GR',
ADD COLUMN IF NOT EXISTS sicacred_producao TINYINT(1) DEFAULT 0 COMMENT '0=Homologação, 1=Produção';

-- Criar índice para melhor performance
CREATE INDEX IF NOT EXISTS idx_empresas_sicacred ON empresas(sicacred_cod_fonte);

-- Comentários nas colunas
ALTER TABLE empresas MODIFY COLUMN sicacred_cod_fonte VARCHAR(7) NULL COMMENT 'Código da Fonte (ex: CSL1704)';
ALTER TABLE empresas MODIFY COLUMN sicacred_cod_grp_emp VARCHAR(10) NULL COMMENT 'Código do Grupo Empresa';
ALTER TABLE empresas MODIFY COLUMN sicacred_codigo_erp VARCHAR(10) NULL COMMENT 'Código do Sistema de Gestão/Envio';
ALTER TABLE empresas MODIFY COLUMN sicacred_chave VARCHAR(255) NULL COMMENT 'Chave de Acesso fornecida pela GR';
ALTER TABLE empresas MODIFY COLUMN sicacred_producao TINYINT(1) DEFAULT 0 COMMENT '0=Homologação, 1=Produção';

