<?php
/**
 * Script para criar a tabela perfis_acesso_permissoes_movimentos
 * Execute este script uma vez para criar a tabela no banco de dados
 *
 * Uso: php database/criar_tabela_perfis_acesso_permissoes_movimentos.php [nome_do_banco]
 */

$banco = $argv[1] ?? null;

// Tentar ler configuração do banco
$configPath = __DIR__ . '/../config/database.php';
if (file_exists($configPath)) {
    $dbConfig = require $configPath;
    $master = $dbConfig['master'] ?? null;

    if ($master && !$banco) {
        $banco = $master['database'];
        $host = $master['host'];
        $port = $master['port'] ?? 3306;
        $username = $master['username'];
        $password = $master['password'];
    }
}

// Se não encontrou configuração, usar valores padrão
if (!$banco) {
    $banco = 'Systhema_tenant_master';
    $host = 'localhost';
    $port = 3306;
    $username = 'root';
    $password = '';
}

try {
    $dsn = "mysql:host={$host};port={$port};dbname={$banco};charset=utf8mb4";
    $db = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);

    echo "Conectado ao banco: {$banco}\n\n";

    // Criar tabela perfis_acesso_permissoes_movimentos
    $sql = "
    CREATE TABLE IF NOT EXISTS `perfis_acesso_permissoes_movimentos` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `company_id` int(11) NOT NULL,
      `perfil_acesso_id` int(11) NOT NULL,
      `permissao_id` int(11) NOT NULL COMMENT 'FK para perfis_acesso_permissoes',
      `module` varchar(255) NOT NULL,
      `movimento` varchar(255) NOT NULL COMMENT 'Nome do movimento (ex: aprovar, cancelar, finalizar)',
      `permitido` tinyint(1) NOT NULL DEFAULT 1,
      `created_at` datetime DEFAULT NULL,
      `updated_at` datetime DEFAULT NULL,
      PRIMARY KEY (`id`),
      KEY `idx_company_id` (`company_id`),
      KEY `idx_perfil_acesso_id` (`perfil_acesso_id`),
      KEY `idx_permissao_id` (`permissao_id`),
      KEY `idx_module` (`module`),
      KEY `idx_movimento` (`movimento`),
      UNIQUE KEY `unique_permissao_movimento` (`company_id`, `permissao_id`, `movimento`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    $db->exec($sql);
    echo "✅ Tabela 'perfis_acesso_permissoes_movimentos' criada com sucesso!\n";

    // Adicionar foreign keys (opcional, pode falhar se houver dados inconsistentes)
    try {
        $fk1Sql = "
        ALTER TABLE `perfis_acesso_permissoes_movimentos`
        ADD CONSTRAINT `fk_perfis_acesso_permissoes_movimentos_perfil`
        FOREIGN KEY (`perfil_acesso_id`)
        REFERENCES `perfis_acesso` (`id`)
        ON DELETE CASCADE;
        ";
        $db->exec($fk1Sql);
        echo "✅ Foreign key para perfis_acesso criada com sucesso!\n";
    } catch (Exception $e) {
        echo "⚠️  Aviso: Não foi possível criar a foreign key para perfis_acesso (pode ser normal se já existir): " . $e->getMessage() . "\n";
    }

    try {
        $fk2Sql = "
        ALTER TABLE `perfis_acesso_permissoes_movimentos`
        ADD CONSTRAINT `fk_perfis_acesso_permissoes_movimentos_permissao`
        FOREIGN KEY (`permissao_id`)
        REFERENCES `perfis_acesso_permissoes` (`id`)
        ON DELETE CASCADE;
        ";
        $db->exec($fk2Sql);
        echo "✅ Foreign key para perfis_acesso_permissoes criada com sucesso!\n";
    } catch (Exception $e) {
        echo "⚠️  Aviso: Não foi possível criar a foreign key para perfis_acesso_permissoes (pode ser normal se já existir): " . $e->getMessage() . "\n";
    }

    echo "\n✅ Processo concluído com sucesso!\n";

} catch (Exception $e) {
    echo "❌ Erro: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
    exit(1);
}

