<?php
/**
 * Script para criar a tabela perfis_acesso
 * Execute este script uma vez para criar a tabela no banco de dados
 *
 * Uso: php database/criar_tabela_perfis_acesso.php [nome_do_banco]
 */

$banco = $argv[1] ?? null;

// Tentar ler configuração do banco
$configPath = __DIR__ . '/../config/database.php';
if (file_exists($configPath)) {
    $dbConfig = require $configPath;
    $master = $dbConfig['master'] ?? null;

    if ($master && !$banco) {
        $banco = $master['database'];
        $host = $master['host'];
        $port = $master['port'] ?? 3306;
        $username = $master['username'];
        $password = $master['password'];
    }
}

// Se não encontrou configuração, usar valores padrão
if (!$banco) {
    $banco = 'Systhema_tenant_master';
    $host = 'localhost';
    $port = 3306;
    $username = 'root';
    $password = '';
}

try {
    $dsn = "mysql:host={$host};port={$port};dbname={$banco};charset=utf8mb4";
    $db = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);

    echo "Conectado ao banco: {$banco}\n\n";

    // Criar tabela perfis_acesso
    $sql = "
    CREATE TABLE IF NOT EXISTS `perfis_acesso` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `company_id` int(11) NOT NULL,
      `nome` varchar(255) NOT NULL,
      `descricao` text DEFAULT NULL,
      `ativo` tinyint(1) NOT NULL DEFAULT 1,
      `created_at` datetime DEFAULT NULL,
      `updated_at` datetime DEFAULT NULL,
      PRIMARY KEY (`id`),
      KEY `idx_company_id` (`company_id`),
      KEY `idx_ativo` (`ativo`),
      UNIQUE KEY `unique_company_nome` (`company_id`, `nome`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    $db->exec($sql);
    echo "✅ Tabela 'perfis_acesso' criada com sucesso!\n";

    // Verificar se a coluna perfil_acesso_id já existe na tabela usuarios
    $checkColumn = $db->query("SHOW COLUMNS FROM usuarios LIKE 'perfil_acesso_id'");
    if ($checkColumn->rowCount() == 0) {
        // Adicionar coluna perfil_acesso_id na tabela usuarios
        $alterSql = "
        ALTER TABLE `usuarios`
        ADD COLUMN `perfil_acesso_id` int(11) DEFAULT NULL AFTER `role`,
        ADD KEY `idx_perfil_acesso_id` (`perfil_acesso_id`);
        ";

        $db->exec($alterSql);
        echo "✅ Coluna 'perfil_acesso_id' adicionada na tabela 'usuarios'!\n";

        // Adicionar foreign key (opcional, pode falhar se houver dados inconsistentes)
        try {
            $fkSql = "
            ALTER TABLE `usuarios`
            ADD CONSTRAINT `fk_usuarios_perfil_acesso`
            FOREIGN KEY (`perfil_acesso_id`)
            REFERENCES `perfis_acesso` (`id`)
            ON DELETE SET NULL;
            ";
            $db->exec($fkSql);
            echo "✅ Foreign key criada com sucesso!\n";
        } catch (Exception $e) {
            echo "⚠️  Aviso: Não foi possível criar a foreign key (pode ser normal se já existir): " . $e->getMessage() . "\n";
        }
    } else {
        echo "ℹ️  Coluna 'perfil_acesso_id' já existe na tabela 'usuarios'.\n";
    }

    echo "\n✅ Processo concluído com sucesso!\n";

} catch (Exception $e) {
    echo "❌ Erro: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
    exit(1);
}

